<?php
namespace bot\admin\adminClassBuilder;

ini_set("display_errors",1);

use bot\admin\adminTutorial\adminTutorial;
use bot\generalClassBuilder\generalClassBuilder;
use bot\admin\discount\discount;
use bot\admin\serviceFunctions\serviceFunctions;
use bot\admin\adminIbsng\adminIbsng;
use bot\admin\userFunctions\userFunctions;
use bot\admin\gateway\gateway;

require_once __DIR__ . '/../generalClassBuilder.php';
require_once __DIR__ . '/adminIbsng.php';
require_once __DIR__ . '/discount.php';
require_once __DIR__ . '/serviceFunctions.php';
require_once __DIR__ . '/userFunctions.php';
require_once __DIR__ . '/gateway.php';
require_once __DIR__ . '/adminTutorial.php';



class adminClassBuilder extends generalClassBuilder
{
    public adminIbsng $adminIbsng;
    public serviceFunctions $serviceFunctions;
    public discount $discount;
    public userFunctions $userFunctions;
    public gateway $gateway;
    public adminTutorial $adminTutorial;
    public function __construct()
    {
        parent::__construct();
        $this->discount = new discount(parent::getGeneralFunctions(),parent::getGeneralDBFunctions());
        $this->gateway = new gateway(parent::getGeneralFunctions(),parent::getGeneralDBFunctions());
        $this->serviceFunctions = new serviceFunctions(parent::getGeneralFunctions(),parent::getGeneralDBFunctions(),parent::getIbsngHandlers());
        $this->adminIbsng = new adminIbsng(parent::getGeneralFunctions(),parent::getGeneralDBFunctions(),$this->serviceFunctions,parent::getIbsngHandlers());
        $this->userFunctions = new userFunctions(parent::getGeneralFunctions(),parent::getGeneralDBFunctions(),parent::getIbsngHandlers(),$this->serviceFunctions,$this->adminIbsng);
        $this->adminTutorial = new adminTutorial(parent::getGeneralFunctions(),parent::getGeneralDBFunctions());
    }
}