<?php

namespace bot\admin\adminTutorial;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/../generalFunctions.php';

class adminTutorial
{
    private generalDBFunctions $dataBase;
    private generalFunctions $botFunctions;

    public function __construct($generalFunctions, $generalDBFunctions)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
    }

    public function tutorialHandler($callbackData)
    {
        $data = explode("-", $callbackData);
        $action = $data[1];
        if ($action == "os") {
            $this->getOsList();
        }
        else if ($action == "askAddOs") {
            $this->botFunctions->sendMessage("لطفا نام سیستم عامل را ارسال کنید");
            $this->botFunctions->setStep("tutorial-addOs");
        }
        else if ($action == "addOs") {
            $this->addOs();
        }
        else if ($action == "deleteSelectedOs") {
            $extra = $data[2];
            $this->deleteSelectedOs($extra);
        }
        else if ($action == "deleteSelectedOsAll") {
            $extra = $data[2];
            $this->deleteSelectedOsAll($extra);
        }
        else if ($action == "list") {
            $this->getTutorialList();
        }
        else if ($action == "askAddTutorial") {
            $this->botFunctions->sendMessage("لطفا نام آموزش را ارسال کنید و سپس از طریق منو آموزش اطلاعات آن را ویرایش کنید");
            $this->botFunctions->setStep("tutorial-addTutorial");
        }
        else if ($action == "addTutorial") {
            $this->addTutorial();
        }
        else if ($action == "editTutorial") {
            $tutorialId = $data[2];
            $this->editTutorial($tutorialId);
        }
        else if ($action == "editSelectedTutorial") {
            $action = $data[2] ?? null;
            $tutorialId = $data[3] ?? NULL;
            $extra = $data[4] ?? NULL;
            $this->editSelectedTutorial($action, $tutorialId, $extra);
        }
    }

    public function getOsList()
    {
        $osListKeyboard = $this->getOsListKeyboard();
        $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: 'برای حذف هر سیستم عامل روی آن کلیک کنید', keyboardInput: $osListKeyboard);
    }

    private function getOsListKeyboard()
    {
        $list = $this->dataBase->selectFromDB("tutorial_os", ["*"]);
        $keyboard = [];
        foreach ($list as $item) {
            $keyboard[] = ['text' => $item['name'], 'callback_data' => 'tutorial-deleteSelectedOs-' . $item['id']];
        }
        $keyboard[] = ['text' => 'افزودن سیستم عامل جدید➕', 'callback_data' => 'tutorial-askAddOs'];
        $backKeyboard = ['text' => 'بازگشت⬅️', 'callback_data' => 'tutorial'];
        return $this->botFunctions->addBackAndChunk($keyboard, 2, $backKeyboard);
    }

    private function addOs()
    {
        $this->dataBase->insertToDB("tutorial_os", ["name"], [userText]);
        $this->getOsList();
        $this->botFunctions->sendMessage("سیستم عامل با موفقیت اضافه شد ✅" . "\n\n" . "لطفا از منو انتخاب کنید", messageIdToReply: $this->botFunctions->getMenuMessageId());
        $this->botFunctions->setStep("home");

    }

    private function deleteSelectedOs(string $osId)
    {
        if ($this->osHasTutorial($osId)) {
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => 'حذف سیستم عامل و تمام آموزش ها', 'callback_data' => 'tutorial-deleteSelectedOsAll-' . $osId]
                    ]
                ]
            ];
            $this->botFunctions->sendMessage(" سیستم عامل انتخاب شده دارای آموزش است، درصورت تمایل به حذف سیستم عامل، تمامی آموزش های این سیستم عامل نیز حذف خواهند شد،", keyboardInput: $keyboard, messageIdToReply: $this->botFunctions->getMenuMessageId());

        }
        else {
            $this->dataBase->deleteFromDB("tutorial_os", "id=" . $osId);
            $this->getOsList();
            $this->botFunctions->sendMessage("سیستم عامل با موفقیت حذف شد ✅" . "\n\n" . "لطفا از منو انتخاب کنید", messageIdToReply: $this->botFunctions->getMenuMessageId());
        }
    }

    private function osHasTutorial(string $osId)
    {
        return $this->dataBase->selectFromDB("tutorial", ["*"], "os_id=$osId")[0];
    }

    private function deleteSelectedOsAll($osId)
    {
        $this->botFunctions->deleteUserMessage(messageId);
        $this->dataBase->deleteFromDB("tutorial_os", "id=" . $osId);
        $this->dataBase->deleteFromDB("tutorial", "os_id=" . $osId);
        $this->getOsList();
        $this->botFunctions->sendMessage("سیستم عامل و آموزش ها با موفقیت حذف شد ✅" . "\n\n" . "لطفا از منو انتخاب کنید", messageIdToReply: $this->botFunctions->getMenuMessageId());
    }

    private function getTutorialList()
    {
        $tutorials = $this->dataBase->selectFromDB("tutorial", ["*"]);
        $keyboard = [];
        foreach ($tutorials as $tutorial) {
            $keyboard[] = ["text" => $tutorial["name"], "callback_data" => 'tutorial-editTutorial-' . $tutorial["id"]];
        }
        $keyboard[] = ['text' => 'افزودن آموزش جدید➕', 'callback_data' => 'tutorial-askAddTutorial'];
        $backKeyboard = ['text' => 'بازگشت⬅️', 'callback_data' => 'tutorial'];
        $keyboard = $this->botFunctions->addBackAndChunk($keyboard, 2, $backKeyboard);
        $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: 'برای ویرایش هر آموزش روی آن کلیک کنید', keyboardInput: $keyboard);
    }

    private function addTutorial()
    {
        $this->dataBase->insertToDB("tutorial", ["name"], [userText]);
        $this->getTutorialList();
        $this->botFunctions->sendMessage("آموزش با موفقیت اضافه شد ✅" . "\n\n" . "لطفا از منو انتخاب کنید", messageIdToReply: $this->botFunctions->getMenuMessageId());
        $this->botFunctions->setStep("home");

    }

    private function editTutorial($tutorialId)
    {
        $details = $this->getTutorialDetails($tutorialId);
        $text = $details["text"];
        $keyboard = $details["keyboard"];
        $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(), text: $text, keyboardInput: $keyboard);
    }

    private function getTutorialDetails($tutorialId)
    {
        $data = $this->dataBase->selectFromDB("tutorial", ["*"], "id=$tutorialId")[0];
        $name = $data["name"];
        $osList = explode(",", $data["os_id"]);
        $osName = "";
        foreach ($osList as $osId) {
            $osName .= $this->getOsName($osId) . ",";
        }
        $tutorialText = $data["text"] ?? "ندارد";
        $files = $data["files"] ?? "ندارد";

        $text = '1️⃣ نام: ' . $name . "\n\n" .
            '2️⃣ توضیحات آموزش: ' . $tutorialText . "\n\n" .
            '3️⃣ سیستم عامل: ' . $osName . "\n\n";

        $keyboard = ['inline_keyboard' =>
            [
                [
                    ['text' => 'تغییر نام آموزش ✍️', 'callback_data' => 'tutorial-editSelectedTutorial-name-' . $tutorialId],
                    ['text' => 'تغییر متن آموزش 📝', 'callback_data' => 'tutorial-editSelectedTutorial-text-' . $tutorialId]
                ],
                [
                    ['text' => 'تغییر سیستم عامل آموزش 🖥', 'callback_data' => 'tutorial-editSelectedTutorial-os-' . $tutorialId],
                    ['text' => 'تغییر فایل های آموزش 📂', 'callback_data' => 'tutorial-editSelectedTutorial-files-' . $tutorialId]
                ],
                [
                    ['text' => 'حذف آموزش 🗑', 'callback_data' => 'tutorial-editSelectedTutorial-delete-' . $tutorialId],
                    ['text' => 'بازگشت⬅️', 'callback_data' => 'tutorial-list']
                ]
            ]
        ];
        $data = ['name' => $name, 'text' => $tutorialText, 'files' => $files, 'osName' => $osName];
        return ['text' => $text, 'array' => $data, 'keyboard' => $keyboard];
    }

    private function getOsName($os_id)
    {
        return $this->dataBase->selectFromDB("tutorial_os", ["name"], "id=$os_id")[0]['name'] ?? "ندارد";
    }

    private function editSelectedTutorial($action, $tutorialId, $extra = NULL)
    {
        if ($action == "delete") {
            $this->dataBase->deleteFromDB("tutorial", "id=" . $tutorialId);
            $this->getTutorialList();
        }
        else if ($action == "os") {
            $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(),
                text: "سیستم عامل های مورد نظر را انتخاب کنید", keyboardInput: $this->getTutorialOsKeyboard($tutorialId));
        }
        else if ($action == "updateOs") {
            $tutorialOs = $this->dataBase->selectFromDB("tutorial", ['os_id'], "id=" . $tutorialId)[0]['os_id'];
            $values = array_filter(array_map('trim', explode(',', $tutorialOs)));
            if (in_array($extra, $values, TRUE)) {
                $values = array_diff($values, [$extra]);
            }
            else {
                $values[] = $extra;
            }
            $tutorialOs = implode(',', $values);

            $this->dataBase->updateToDB(
                "tutorial",
                ['os_id'],
                [$tutorialOs],
                "id=$tutorialId"
            );
            $this->botFunctions->editMessage(messageId: $this->botFunctions->getMenuMessageId(),
                text: "سیستم عامل های مورد نظر را انتخاب کنید", keyboardInput: $this->getTutorialOsKeyboard($tutorialId));
        }
        else if ($action == "files") {
            $this->sendCurrentTutorialFiles($tutorialId);
            $this->botFunctions->setStep("tutorial-editSelectedTutorial-addFiles-$tutorialId");
            $keyboard = [
                'inline_keyboard' =>[
                    [
                        ['text' => 'لغو❌' ,'callback_data' => 'tutorial-editSelectedTutorial-cancelFiles'],
                    ]
                ]
            ];
            $this->botFunctions->sendMessage(" لطفا فایل های مدنظر خود را باهم ارسال کنید، برای لغو از دکمه زیر استفاده کنید",keyboardInput: $keyboard);
        }
        else if ($action == "cancelFiles") {
            $this->botFunctions->deleteUserMessage(messageId: messageId);
            $this->botFunctions->setStep("home");
        }
        else if ($action == "addFiles") {
            $response = $this->botFunctions->getFile();
            $link = $response["link"];
            $type = $response["type"];
            $name = $response["name"];
            $this->saveTutorialAddress($link, $type,$tutorialId,$name);
        }
        else if ($action == "finish") {
            $this->finishSendingFiles($tutorialId);
        }
        else if ($action == "deleteFile") {
            $this->deleteTutorialFile($tutorialId,$extra);
        }
        else if ($action == "update") {
            $this->botFunctions->deleteUserMessage(messageId: messageId);
            $this->dataBase->updateToDB("tutorial", [$extra],[userText], "id=" . $tutorialId);
            $this->editTutorial($tutorialId);
            $this->botFunctions->sendMessage("با موفقیت آپدیت شد",messageIdToReply: $this->botFunctions->getMenuMessageId());
            $this->botFunctions->setStep("home");
        }
        else
        {
            $data = $this->dataBase->selectFromDB("tutorial", [$action], "id=" . $tutorialId)[0][$action] ?? "ثبت نشده";
            $this->botFunctions->sendMessage("مقدار فعلی");
            $this->botFunctions->sendMessage($data);
            $keyboard = [
                'inline_keyboard' =>[
                    [
                        ['text' => 'لغو' ,'callback_data' => 'tutorial-editSelectedTutorial-cancelFiles'],
                    ]
                ]
            ];
            $this->botFunctions->setStep("tutorial-editSelectedTutorial-update-$tutorialId-$action");
            $this->botFunctions->sendMessage("مقدار جدید را ارسال کنید یا از طریق دکمه زیر عملیات را لغو کنید",keyboardInput: $keyboard);
        }
    }

    private function getTutorialOsKeyboard($tutorialId)
    {
        $osList = $this->dataBase->selectFromDB("tutorial_os", ["*"]);
        $tutorialOs = $this->dataBase->selectFromDB("tutorial", ['os_id'], "id=" . $tutorialId)[0]['os_id'] ?? "";
        $tutorialOs = explode(",", $tutorialOs);
        $keyboard = [];
        foreach ($osList as $os) {
            $keyboard[] = ['text' => in_array($os['id'], $tutorialOs) ? "✅" : "❌", 'callback_data' => 'tutorial-editSelectedTutorial-updateOs-' . $tutorialId . '-' . $os['id']];
            $keyboard[] = ['text' => $this->getOsName($os["id"]), 'callback_data' => 'tutorial-message?-چیزی وجود ندارد ❌'];

        }
        return $this->botFunctions->addBackAndChunk($keyboard, 2, ['text' => 'بازگشت⬅️', 'callback_data' => 'tutorial-editTutorial-' . $tutorialId]);
    }

    private function saveTutorialAddress($link, $type,$tutorialId,$name)
    {
        $data = $this->dataBase->selectFromDB("tutorial", ["files"],"id=" . $tutorialId)[0]['files'] ?? "";
        $newFiles = ['link'=> $link, 'type'=> $type,'id' => rand(0,999999999)];
        if (str_contains($data,json_encode($newFiles))) {
            return FALSE;
        }
        $currentFiles = json_decode($data, true);
        $currentFiles[] = $newFiles;
        $this->dataBase->updateToDB("tutorial", ['files'],[json_encode($currentFiles)],"id='$tutorialId'");
        $keyboard = [
            'inline_keyboard' =>
                [
                    [
                        ['text' => 'تایید','callback_data' => 'tutorial-editSelectedTutorial-finish-' . $tutorialId]
                    ]
            ]
        ];
        $this->botFunctions->sendMessage(text: "درصورتی که ارسال فایل ها تمام شده روی دکمه تایید کلیک کنید، در غیر اینصورت فایل های مدنظر خود را ارسال کنید", keyboardInput: $keyboard, messageIdToReply: $this->botFunctions->getMenuMessageId());
        return TRUE;
    }

    private function sendCurrentTutorialFiles($tutorialId)
    {
        $data = $this->dataBase->selectFromDB("tutorial",["files"],"id=" . $tutorialId)[0]['files'] ?? NULL;
        if (is_null($data)) {
            $this->botFunctions->sendMessage("هیچ فایلی برای این آموزش ثبت نشده");
            return;
        }
        $data = json_decode($data, true);
        foreach ($data as $file) {
            $keyboard = [
                'inline_keyboard' =>
                    [
                        [
                            ['text'=>'test','callback_data' => 'tutorial-editSelectedTutorial-deleteFile-' . $tutorialId . '-' . $file['id']],
                        ]
                    ]
            ];
            $this->botFunctions->sendMedia(type: $file["type"], media: new \CURLFile($file["link"]),replyMarkup: $keyboard);
        }
    }

    private function finishSendingFiles($tutorialId)
    {
        $this->botFunctions->deleteUserMessage(messageId: $this->botFunctions->getMenuMessageId());
        $data = $this->getTutorialDetails($tutorialId);
        $response = $this->botFunctions->sendMessage(text: $data['text'],keyboardInput: $data['keyboard']);
        $this->botFunctions->updateMenuMessageId($response['result']['message_id']);
        $this->botFunctions->setStep("home");
    }

    private function deleteTutorialFile($tutorialId, $extra)
    {
        $data = $this->dataBase->selectFromDB("tutorial", ["files"], "id=" . $tutorialId)[0]['files'];
        $data = json_decode($data, true) ?: [];

        foreach ($data as $key => $file) {
            if ($file["id"] == $extra) {
                unset($data[$key]);
                $data = array_values($data);
                $this->dataBase->updateToDB(
                    "tutorial",
                    ['files'],
                    [json_encode($data, JSON_UNESCAPED_UNICODE)],
                    "id='$tutorialId'"
                );
                $this->botFunctions->deleteUserMessage(messageId: messageId);
                $this->botFunctions->sendMessage("فایل با موفقیت حذف شد");
                return;
            }
        }
    }
}