<?php

class IBSngDB
{
//    private string $address = "65.108.57.172";
    private string $address = "167.235.132.166";
    private string $database = "IBSng";
    private string $dbUsername = "ibsremote";
//    private string $dbPassword = "121549783";
    private string $dbPassword = "121549783Seven!";
    private string $IBSngPort = "5432";
    private $connection;

    public function __construct()
    {
        $this->connection = pg_connect("host=" . $this->address . " port=" . $this->IBSngPort
            . " dbname=" . $this->database . " user=" . $this->dbUsername . " password=" . $this->dbPassword);
    }

    public function getAllUserIds()
    {
        $query = "SELECT user_id FROM users";
        $response = $this->sentQuery($query);
        if ($response) {
            return ['result' => TRUE, "data" => pg_fetch_all_columns($response)];
        }
        return ['result' => FALSE];
    }

    public function getAllUserNames($input = "normal_username")
    {
        $query = "SELECT $input FROM normal_users";
        $response = $this->sentQuery($query);
        if ($response) {
            return ['result' => TRUE, "data" => pg_fetch_all_columns($response)];
        }
        return ['result' => FALSE];
    }

    public function getUserDetails($user, $isUsername)
    {
        if ($isUsername) {
            $user = $this->getUserId($user)["data"];
        }
        $tmp = pg_fetch_all($this->sentQuery("SELECT * FROM users WHERE user_id='" . $user . "'"));
        if (empty($tmp)) {
            return FALSE;
        }
        $tmp = $tmp[0];
        $userDetails['userId'] = $user;
        $userDetails['groupId'] = $tmp['group_id'];

        $groupDetails = $this->getGroupDetails($tmp['group_id'], FALSE);
        foreach ($groupDetails as $index => $value) {
            $userDetails["group_" . $index] = $value;
        }

        $tmp = pg_fetch_all($this->sentQuery("SELECT * FROM normal_users WHERE user_id='" . $user . "'"))[0];
        $userDetails['userName'] = $tmp['normal_username'];
        $userDetails['password'] = $tmp['normal_password'];
        $tmp = pg_fetch_all($this->sentQuery("SELECT * FROM user_attrs WHERE user_id='" . $user . "'"));
        foreach ($tmp as $info) {
            $userDetails["user_" . $info['attr_name']] = $info['attr_value'];
        }

        return $userDetails;

    }

    public function getUserId($username)
    {
        $query = "select user_id from normal_users where normal_username='$username'";
        $response = pg_fetch_all($this->sentQuery($query));
        if (!empty($response)) {
            return ['result' => TRUE, "data" => $response[0]['user_id']];
        }
        return ['result' => FALSE, 'error' => "user not found!"];

    }

    public function deleteUser($user, $isUsername)
    {
        if ($isUsername) {
            $user = $this->getUserId($user)["data"];
        }
        $queries[] = "DELETE FROM normal_users where user_id='$user'";
        $queries[] = "DELETE FROM user_attrs where user_id='$user'";
        $queries[] = "DELETE FROM add_user_save_details where add_user_save_id='$user'";
        $queries[] = "DELETE FROM add_user_saves where add_user_save_id='$user'";
        $queries[] = "DELETE FROM users where user_id='$user'";
        foreach ($queries as $query) {
            try {
                $this->sentQuery($query);
            } catch (Exception $e) {
                echo "e";
            }
        }
    }

    public function getBrokenUserNames()
    {
        $allUserNamesIds = $this->getAllUserNames("user_id")["data"];
        $allUserIds = $this->getAllUserIds()["data"];
        return array_diff($allUserIds, $allUserNamesIds);
    }

    public function deleteBrokenUserNames()
    {
        $brokenUserNamesIds = $this->getBrokenUserNames();
        foreach ($brokenUserNamesIds as $id) {
            $this->deleteUser($id, FALSE);
            echo "Broken user is deleted : " . $id . "\n";
        }
    }

    public function checkUserExpire($userId, $before)
    {
        if ($before < 100000) {
            $before = strtotime("-" . $before . " days", time());
        }
        $expireDate = $this->getUserExpireDate($userId, FALSE);
        if ($expireDate < $before) {
            return TRUE;
        }

        return FALSE;
    }

    public function getAllExpiredUsers($before)
    {
        if ($before < 100000) {
            $before = strtotime("-" . $before . " days", time());
        }
        $allUsersId = $this->getAllUserIds();
        if (!$allUsersId['result']) {
            return $allUsersId;
        }
        $allUsersId = $allUsersId['data'];
        $expired = [];
        foreach ($allUsersId as $user) {
            if ($this->checkUserExpire($user, $before)) {
                $expired[] = $user;
            }
        }
        return $expired;
    }

    public function getUserExpireDate($user, $isUsername)
    {
        if ($isUsername) {
            $user = $this->getUserId($user)["data"];
        }
        $userDetails = $this->getUserDetails($user, FALSE);
        if ($userDetails) {
            $userRelExpireDate = $userDetails['user_rel_exp_date'] ?? 0;
            $userAbsExpireDate = $userDetails['user_abs_exp_date'] ?? 0;
            $userFirstLogin = $userDetails['user_first_login'] ?? 0;
            $userGroupRelExpireDate = $userDetails['group_rel_exp_date'] ?? 0;
            $userGroupAbsExpireDate = $userDetails['group_abs_exp_date'] ?? 0;

            $absExpire = strtotime("9999-12-12");
            $relExpire = strtotime("9999-12-12");

            if ($userAbsExpireDate != 0) {
                $absExpire = $userAbsExpireDate;
            }
            else if ($userGroupAbsExpireDate != 0) {
                $absExpire = $userGroupAbsExpireDate;
            }
            if ($userRelExpireDate != 0) {
                $relExpire = $userRelExpireDate;
            }
            else if ($userGroupRelExpireDate != 0) {
                $relExpire = $userGroupRelExpireDate;
            }
            if ($userFirstLogin == 0) {
                $userFirstLogin = time();
            }
            return min($absExpire, ($userFirstLogin + $relExpire));
        }
    }

    public function deleteAllExpiredUser($before)
    {
        if ($before < 100000) {
            $before = strtotime("-" . $before . " days", time());
        }
        $start = microtime(TRUE);
        $allExpiredUsers = $this->getAllExpiredUsers($before);
        echo "GET ALL EXPIRED USERS : " . microtime(TRUE) - $start . "\n";
        foreach ($allExpiredUsers as $user) {
            $this->deleteUser($user, FALSE);
        }
    }

    public function getGroupDetails($group, $isGroupName)
    {
        $query = $isGroupName ? "SELECT * from groups where group_name='$group'" : "SELECT * from groups where group_id='$group'";

        $group = pg_fetch_all($this->sentQuery($query));

        if ($group) {
            $groupId = $group[0]['group_id'];
            $groupName = $group[0]['group_name'];
        }
        else {
            return ['result' => FALSE, 'error' => "Group not found"];
        }

        $groupDetails['id'] = $groupId;
        $groupDetails['name'] = $groupName;
        $tmp = pg_fetch_all($this->sentQuery("SELECT * from group_attrs where group_id='$groupId'"));
        foreach ($tmp as $info) {
            $groupDetails[$info['attr_name']] = $info['attr_value'];
        }
        return $groupDetails;

    }

    public function addDaysToAllUsers($days)
    {
        $allUsersId = $this->getAllUserIds()['data'];
        foreach ($allUsersId as $user) {
            $oldExpireDate = $this->getUserExpireDate($user, FALSE);
            $remainTimes = $oldExpireDate - time() <= 0 ? 0 : (($oldExpireDate-time())/(3600*24));
            $newExpireDate = ($remainTimes + $days)*3600*24;
            $this->sentQuery("DELETE from user_attrs where user_id=$user and (attr_name='abs_exp_date' or attr_name='rel_exp_date' or attr_name='first_login')");
            $this->sentQuery("INSERT INTO user_attrs(user_id,attr_name,attr_value) VALUES ($user,'rel_exp_date',$newExpireDate)");
            echo "USER $user ADDED \n";
        }
    }
    public function addToUserAttrs($user,$attrName,$attrValue,$isUsername)
    {
        if ($isUsername) {
            $user = $this->getUserId($user)["data"];
        }
        $this->sentQuery("insert into user_attrs (user_id,attr_name,attr_value) VALUES ($user,'$attrName','$attrValue')");
    }
    public function sentQuery($query)
    {
        try {
            return pg_query($this->connection, $query);
        } catch (Exception $e) {
            return "e";
        }
    }
}
$ib = new IBSngDB();

/*echo count($ib->getAllUserIds()['data']);
sleep(5);
$ib->deleteBrokenUserNames();
$ib->deleteAllExpiredUser(365);
echo count($ib->getAllUserIds()['data']);
sleep(5);*/


//echo count($ib->getAllExpiredUsers(365));
$ib->addDaysToAllUsers(7);

