<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاکتور خرید</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Noto+Naskh+Arabic:wght@400;700&display=swap');

        body {
            direction: rtl;
            font-family: 'Noto Naskh Arabic', sans-serif;
            background: #f9f9f9;
            padding: 20px;
            text-align: center;
        }

        .receipt {
            max-width: 600px;
            background: #fff;
            padding: 20px;
            margin: auto;
            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        .header {
            text-align: center;
        }

        h1 {
            font-size: 22px;
            margin-bottom: 10px;
        }

        .info, .customer {
            text-align: right;
            margin-bottom: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        table, th, td {
            border: 1px solid #333;
        }

        th, td {
            padding: 8px;
            text-align: center;
        }

        .total {
            text-align: right;
            margin-top: 10px;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            font-weight: bold;
        }
    </style>
</head>
<body>

<div class="receipt">
    <div class="header">
        <h1>کلید سازی اوستا محمود</h1>
    </div>

    <div class="info">
        <p><strong>شماره فاکتور:</strong> <?php echo isset($_GET['invoice']) ? htmlspecialchars($_GET['invoice']) : 'نامشخص'; ?></p>
    </div>

    <div class="sender">
        <p><strong>فرستنده:</strong> خراسان رضوی، شهرستان فیض‌ آباد، خیابان امام رضا شرقی، بین خیابان دانش‌آموز و آتش نشانی</p>
    </div>

    <div class="receiver">
        <p><strong>گیرنده:</strong> <?php echo isset($_GET['receiver']) ? htmlspecialchars($_GET['receiver']) : 'نامشخص'; ?></p>
    </div>

    <table>
        <thead>
        <tr>
            <th>عنوان</th>
            <th>تعداد</th>
            <th>مبلغ واحد (تومان)</th>
            <th>مبلغ کل (تومان)</th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td><?php echo isset($_GET['title']) ? htmlspecialchars($_GET['title']) : 'نامشخص'; ?></td>
            <td><?php echo isset($_GET['quantity']) ? (int)$_GET['quantity'] : 0; ?></td>
            <td><?php echo isset($_GET['unit_price']) ? number_format((int)$_GET['unit_price']) : 0; ?></td>
            <td>
                <?php
                $quantity = isset($_GET['quantity']) ? (int)$_GET['quantity'] : 0;
                $unit_price = isset($_GET['unit_price']) ? (int)$_GET['unit_price'] : 0;
                echo number_format($quantity * $unit_price);
                ?>
            </td>
        </tr>
        </tbody>
    </table>

    <div class="total">
        <p><strong>روش پرداخت:</strong> سداد</p>
        <p><strong>مجموع مبلغ نهایی:</strong>
            <?php echo number_format($quantity * $unit_price); ?> تومان
        </p>
    </div>

    <div class="footer">
        <p>کلید سازی اوستا محمود</p>
        <p>از خرید شما سپاسگزاریم</p>
    </div>
</div>

</body>
</html>
