<?php

namespace bot\user\userBot;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;
use bot\user\accountFunctions\accountFunctions;
use bot\user\serviceFunctions\serviceFunctions;
use bot\user\userClassBuilder\userClassBuilder;
use bot\user\userInfo\userInfo;
use mysql_xdevapi\CrudOperationLimitable;
use mysql_xdevapi\Exception;
use function bot\user\jdf\jdate;

require_once __DIR__ . '/userKeyboards.php';
require_once __DIR__ . '/jdf.php';
require_once __DIR__ . '/userClassBuilder.php';

class userBot
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    private userClassBuilder $userClassBuilder;
    private serviceFunctions $serviceFunctions;
    private accountFunctions $accountFunctions;
    private userInfo $userInfo;
    private array $userStrings;

    public function __construct()
    {
        $this->userClassBuilder = new userClassBuilder();
        $this->dataBase = $this->userClassBuilder->getGeneralDBFunctions();
        $this->botFunctions = $this->userClassBuilder->getGeneralFunctions();
        $this->IBSngHandlers = $this->userClassBuilder->getIbsngHandlers();
        $this->userInfo = $this->userClassBuilder->userInfo;
        $this->accountFunctions = $this->userClassBuilder->accountFunctions;
        $this->serviceFunctions = $this->userClassBuilder->serviceFunctions;
        $this->userStrings = json_decode(file_get_contents(__DIR__ . "/strings.json"), TRUE);
    }

    public function main(): void
    {

        $step = $this->botFunctions->getStep() ?? "home";
        $lastPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . userId . "-latestPanel'")[0]['value'] ?? NULL;

        $this->botFunctions->sendMessage(json_encode(callback_data));
        // پنل اطلاعات کاربر (دوستانه)
        $userPanelText = "📋 اطلاعات حساب کاربری‌ت:" . "\n\n"
            . "👤 نام کاربری: " . '`' . chatId . '`' . "\n"
            . "📛 یوزرنیم تلگرام: " . '`' . telegramUserName . '`' . "\n"
            . "💠 اسم: " . '`' . telegramFirstName . '`' . "\n\n"
            . "💡 تعداد سرویس‌های فعال: " . $this->accountFunctions->userServicesCount(userId) . "\n\n"
            . $this->userStrings['userAccounts'];

        // لغو خرید
        if (callback_data == "cancelBuy" or userText == "لغو خرید❗️") {
            $this->botFunctions->deleteUserMessage(messageId);
            $this->botFunctions->sendMessage("❌ خریدت کنسل شد رفیق! هر وقت آماده بودی، بازم کنارتم 😉", keyboardInput: remove);
            $this->mainMenu();
        }
        else if (callback_data == "buyService") {
            $this->botFunctions->editMessage(messageId: $lastPanel, text: "🛍 چه نوع سرویسی می‌خوای برداری؟ یکی از گزینه‌های پایین رو بزن 👇", keyboardInput: buyServiceType);
        }
        // سرویس‌های ثابت
        else if (callback_data == "buyFixedService") {
            $servicesKeyboard = $this->serviceFunctions->getServices();
            $this->botFunctions->editMessage(messageId: $lastPanel, text: "📦 اینا سرویس‌های آماده‌ان؛ هر کدوم باحال‌تره انتخاب کن 🤟", keyboardInput: $servicesKeyboard);
        }
        // سرویس کاستوم (شخصی‌سازی)
        else if (callback_data == "buyCustomService") {
            $service = $this->serviceFunctions->checkCustomService();
            if (!$service['result']) {
                return;
            }
            $keyboard = [
                'inline_keyboard' =>
                    [
                        [
                            ['text' => 'بازگشت⬅️', 'callback_data' => 'buyService'],
                        ],
                    ]
            ];
            $this->botFunctions->editMessage(
                messageId: $lastPanel,
                text: "🛠 می‌خوای سرویس شخصی‌سازی شده داشته باشی؟\n💰 هزینه هر روز: " . $service['service']['days_price'] . " تومان ✨",
                keyboardInput: $keyboard
            );
            $this->botFunctions->setStep("buyService-days");
        }
        // مدیریت اکانت‌ها
        else if (callback_data == "manageAccount") {
            $userAccounts = $this->accountFunctions->getUserAccounts();
            $this->botFunctions->editMessage(messageId: $lastPanel, text: $userPanelText, keyboardInput: $userAccounts, parsMode: "MarkdownV2");
        }
        // افزودن اکانت کاربر
        else if (callback_data == "addUserAccount") {
            $this->botFunctions->sendMessage("👤 یوزر و پسوردتو بفرست، هر کدوم تو یه خط جدا ✍️\n\n📌 مثال:\nuser1\npass1");
            $this->botFunctions->setStep("addUserAccount");
        }
        // پیام به ادمین
        else if (callback_data == "adminMessage") {
            $this->botFunctions->sendMessage("📨 هرچی تو دلت هست بگو! پیام مستقیم می‌ره برای مدیریت 🔥",keyboardInput: backKeyboard);
            $this->botFunctions->setStep("adminMessage");
        }
        else if (callback_data == "userInfo") {
            $this->userInfo->start();
        }
        // نمایش جزئیات سرویس جهت خرید
        else if (str_starts_with(callback_data, "showService-")) {
            $data = explode("-", callback_data);
            $serviceId = $data[1];
            $accountId = $data[2] ?? NULL;

            $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId,$accountId);
            if (!$serviceDetails['result']) {
                return;
            }
            $keyboard = $this->serviceFunctions->buyServiceKeyboard($serviceId, $accountId, $serviceDetails['array']['price']);
            $text = $serviceDetails['text'];
            $text .= "\n\n⚡ اگه کد تخفیف داری همین الان بفرست 🤩\n🙌 اگه نداری، روش پرداختتو انتخاب کن";
            $this->botFunctions->editMessage(messageId: $lastPanel, text: $text, keyboardInput: $keyboard);
            $this->botFunctions->setStep("discountCode-$serviceId-$accountId");
        }
        // ویرایش اکانت کاربر
        else if (str_starts_with(callback_data, "editUserAccount-")) {
            $accountId = explode("-", callback_data)[1];
            $keyboard = [
                'inline_keyboard' => [
                    [['text' => "تمدید ♻️", 'callback_data' => 'renewAccount-' . $accountId]],
                    [['text' => "تغییر پسورد 🔑", 'callback_data' => 'changePassword-' . $accountId]],
                    [['text' => "افزایش روز 🗓", 'callback_data' => 'addDays-' . $accountId]],
                    // [['text' => "افزایش حجم 🌐", 'callback_data' => 'addVolume-' . $accountId]],
                    [['text' => "افزایش کاربر 👥", 'callback_data' => 'addMultiLogin-' . $accountId]],
                    [['text' => "قطع اتصال ⛔", 'callback_data' => 'disconnectAccount-' . $accountId]],
                    [['text' => "بازگشت ⬅️", 'callback_data' => 'manageAccount']]
                ]
            ];
            $accountInfo = $this->accountFunctions->getUserAccountInfo($accountId);
            if (!$accountInfo) {
                $this->botFunctions->sendMessage("❌ اکانتی که دنبالش می‌گردی پیدا نشد 😕");
                $this->mainMenu();
                return;
            }
            $text = $accountInfo['text'] . "\n\n⚙️ از این منو هرکاری با اکانتت داری می‌تونی انجام بدی 👇";
            $this->botFunctions->editMessage(messageId: $lastPanel, text: $text, keyboardInput: $keyboard);
        }
        // قطع اتصال اکانت
        else if (str_starts_with(callback_data, "disconnectAccount-")) {
            $accountId = explode("-", callback_data)[1];
            $this->accountFunctions->disconnectAccount($accountId);
            $userAccounts = $this->accountFunctions->getUserAccounts();
            $this->botFunctions->sendMessage("✅ اتصال اکانتت قطع شد! هر زمان بخوای دوباره می‌تونی وصلش کنی 😉");
            $response = $this->botFunctions->sendMessage($userPanelText, parsMode: "MarkdownV2", keyboardInput: $userAccounts);
            $this->submitNewMenu($response);
        }
        // درخواست تغییر پسورد
        else if (str_starts_with(callback_data, "changePassword-")) {
            $this->botFunctions->sendMessage("🔑 پسورد جدید رو بفرست (فقط شامل عدد و حرف باشه)\n\n📌 مثال: 123456AbcD");
            $this->botFunctions->setStep(callback_data);
        }
        // اعمال تغییر پسورد
        else if (str_starts_with($step, "changePassword-")) {
            $accountId = explode("-", $step)[1];
            $newPassword = userText;
            if (!preg_match('/^[A-Za-z0-9]+$/', $newPassword)) {
                $this->botFunctions->sendMessage("❌ پسوردت قابل قبوله نیست 😬\n🔐 فقط عدد و حروف لاتین مجازه\n📌 مثال: 123456AbcD", keyboardInput: backKeyboard);
                return;
            }
            $userName = $this->dataBase->selectFromDB("user_accounts", ["account_username"], "id='$accountId'")[0]['account_username'];
            $this->IBSngHandlers->editUser($userName, "normalAttrs", $newPassword, "password");
            $this->botFunctions->sendMessage("✅ پسورد جدیدت با موفقیت ثبت شد! 🚀 از منو ادامه بده", messageIdToReply: $lastPanel);
        }
        // تمدید اکانت → فهرست سرویس‌ها
        else if (str_starts_with(callback_data, "renewAccount-")) {
            $accountId = explode("-", callback_data)[1];
            $servicesKeyboard = $this->serviceFunctions->getServices(TRUE, $accountId);
            $this->botFunctions->editMessage(messageId: $lastPanel, text: "🧾 برای تمدید، یکی از سرویس‌های زیر رو انتخاب کن 👇", keyboardInput: $servicesKeyboard);
        }
        // افزودن روز (کاستوم)
        else if (str_starts_with(callback_data, "addDays-")) {
            $service = $this->serviceFunctions->checkCustomService();
            if (!$service['result']) {
                return;
            }
            $accountId = explode("-", callback_data)[1];
            $this->botFunctions->editMessage(
                messageId: $lastPanel,
                text: "🗓 چند روز می‌خوای اضافه کنی؟\n💰 قیمت هر روز: " . $service['service']['days_price'] . " تومن",
                keyboardInput: backKeyboard
            );
            $this->botFunctions->setStep("AddCustomService-days-$accountId");
        }
        // افزودن حجم (در صورت فعال بودن)
        else if (str_starts_with(callback_data, "addVolume-")) {
            $service = $this->serviceFunctions->checkCustomService();
            if (!$service['result']) {
                return;
            }
            $accountId = explode("-", callback_data)[1];
            $this->botFunctions->editMessage(
                messageId: $lastPanel,
                text: "🌐 چقدر حجم می‌خوای اضافه کنی؟ (واحد گیگ)\n💰 قیمت هر گیگ: " . $service['service']['volume_price'] . " تومن",
                keyboardInput: backKeyboard
            );
            $this->botFunctions->setStep("AddCustomService-volume-$accountId");
        }
        // افزودن تعداد کاربر همزمان
        else if (str_starts_with(callback_data, "addMultiLogin-")) {
            $service = $this->serviceFunctions->checkCustomService();
            if (!$service['result']) {
                return;
            }
            $accountId = explode("-", callback_data)[1];
            $this->botFunctions->editMessage(
                messageId: $lastPanel,
                text: "👥 چندتا کاربر همزمان می‌خوای اضافه کنی؟\n💰 قیمت هر کاربر: " . $service['service']['multi_price'] . " تومن",
                keyboardInput: backKeyboard
            );
            $this->botFunctions->setStep("AddCustomService-multi-$accountId");
        }
        // پرداخت‌ها (درگاه/روش)
        else if (str_starts_with(callback_data, "payService-")) {
            $data = explode("-", callback_data);
            $gatewayId = $data[2];
            $buyType = $data[1];

            if ($buyType == "custom") {
                $days = $data[3];
                $volume = $data[4];
                $multiLogin = $data[5];
                $price = $data[6];

                if ($gatewayId == 1) {
                    $card = $this->dataBase->selectFromDB("gateways", ["*"], "id='1'")[0];
                    $this->botFunctions->sendMessage(
                        "🧾 سفارش کاستوم تو:\n" .
                        "• روز: $days\n" .
                        "• حجم: $volume گیگ\n" .
                        "• کاربر همزمان: $multiLogin تا\n" .
                        "• مبلغ: $price تومان 💳"
                    );
                    $this->botFunctions->sendMessage("💳 لطفاً مبلغ رو به این کارت واریز کن و تو پیام بعدی اسکرین‌شات رسیدت رو بفرست:\n" . $card['value']);
                    $this->botFunctions->sendMessage("‼️ توجه: اولین عکس/فایلی که بفرستی به عنوان رسید پرداخت ثبت می‌شه.", keyboardInput: cancelPurchase);
                    $this->botFunctions->setStep("sendPaid-custom-$days-$volume-$multiLogin-$price");
                } else if ($gatewayId == 2) {
                    // درگاه دوم (درصورت نیاز)
                }
            }
            else if ($buyType == "normal") {
                $serviceId = $data[3];
                $reNewAccountId = $data[4] ?? "false";
                $price = $data[5] ?? 0;
                $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId);
                if (!$serviceDetails['result']) {
                    return;
                }
                $serviceDetails = $serviceDetails['array'];

                if ($gatewayId == 1) {
                    $card = $this->dataBase->selectFromDB("gateways", ["*"], "id='1'")[0];
                    $this->botFunctions->sendMessage("🧾 سفارش سرویس «" . $serviceDetails['name'] . "» به مبلغ " . $price . " تومان ثبت شد.");
                    $this->botFunctions->sendMessage("💳 لطفاً مبلغ رو به این کارت واریز کن و بعد اسکرین‌شات پرداخت رو همین‌جا بفرست:\n" . $card['value']);
                    $this->botFunctions->sendMessage("‼️ توجه: پیام بعدیِ شما رسید پرداخت محسوب می‌شه.", keyboardInput: cancelPurchase);
                    $this->botFunctions->setStep("sendPaid-" . $serviceId . "-$reNewAccountId-$price");
                } else if ($gatewayId == 2) {
                    // درگاه دوم
                }
            }
            else if ($buyType == "add") {
                $orderId = $data[3];
                $price = $data[4];

                if ($gatewayId == 1) {
                    $card = $this->dataBase->selectFromDB("gateways", ["*"], "id='1'")[0];
                    $this->botFunctions->sendMessage("🧾 آپدیت اکانتت به مبلغ " . $price . " تومان ثبت شد.");
                    $this->botFunctions->sendMessage("💳 لطفاً مبلغ رو به این کارت واریز کن و بعد اسکرین‌شات پرداخت رو بفرست:\n" . $card['value']);
                    $this->botFunctions->sendMessage("‼️ توجه: پیام بعدیِ شما رسید پرداخت محسوب می‌شه.", keyboardInput: cancelPurchase);
                    $this->botFunctions->setStep("sendPaid-add-$orderId-$price");
                } else if ($gatewayId == 2) {
                    // درگاه دوم
                }
            }
        }
        // تغییر پسورد (مرحله ورود پسورد جدید در بالا هندل شد)
        else if (str_starts_with(callback_data, "userInfo-")) {
            $this->userInfo->handler(callback_data);
        }

        // دریافت رسید پرداخت
        else if (str_starts_with($step, "sendPaid-")) {
            $data = explode('-', $step);
            $serviceId = $data[1];

            if (in_array("custom", $data)) {
                $days = $data[2];
                $volume = $data[3];
                $multiLogin = $data[4];
                $price = $data[5];

                $this->botFunctions->sendMessage("✅ رسیدت رسید به دستمون! بلافاصله می‌ره برای بررسی پشتیبانی؛ خیلی زود نتیجه رو اعلام می‌کنیم 🙏🏻", keyboardInput: remove);
                $admin = $this->dataBase->selectFromDB("admins", ["telegram_id"], "telegram_username='" . admin . "'")[0]['telegram_id'];
                $result = $this->botFunctions->forwardMessage($admin);

                $keyboard = [
                    'inline_keyboard' => [
                        [['text' => "تایید ✅", 'callback_data' => "order_response-confirm-custom-$days-$volume-$multiLogin-" . chatId]],
                        [['text' => "رد ❌", 'callback_data' => "order_response-reject_buy-custom-$days-$volume-$multiLogin-" . chatId . "-"]],
                        [['text' => "بلاک 🚫", 'callback_data' => "order_response-block-custom-$days-$volume-$multiLogin-" . chatId . "-"]]
                    ]
                ];

                $this->botFunctions->sendMessage(
                    "🧾 جزئیات سفارش:\n" .
                    "• روز: $days\n" .
                    "• حجم: $volume گیگ\n" .
                    "• کاربر همزمان: $multiLogin\n" .
                    "• مبلغ بعد از تخفیف: $price تومان",
                    id: $admin,
                    keyboardInput: $keyboard,
                    messageIdToReply: $result['result']['message_id'],
                    chatId: $admin
                );
            }
            else if (in_array("add", $data)) {
                $orderId = $data[2];
                $price = $data[3];

                $this->botFunctions->sendMessage("✅ رسیدت ثبت شد؛ تیم پشتیبانی در حال بررسیه. نتیجه خیلی زود بهت اطلاع داده می‌شه 🙏🏻", keyboardInput: remove);
                $admin = $this->dataBase->selectFromDB("admins", ["telegram_id"], "telegram_username='" . admin . "'")[0]['telegram_id'];
                $result = $this->botFunctions->forwardMessage($admin);

                $keyboard = [
                    'inline_keyboard' => [
                        [['text' => "تایید ✅", 'callback_data' => "order_response-confirm-add-$orderId-$price---"]],
                        [['text' => "رد ❌", 'callback_data' => "order_response-reject_buy-add-$orderId-$price---"]],
                        [['text' => "بلاک 🚫", 'callback_data' => "order_response-block-add-$orderId-$price---"]]
                    ]
                ];

                $this->botFunctions->sendMessage(
                    "🧾 جزئیات آپدیت اکانت:\n" .
                    "• مبلغ بعد از تخفیف: $price تومان",
                    id: $admin,
                    keyboardInput: $keyboard,
                    messageIdToReply: $result['result']['message_id'],
                    chatId: $admin
                );
            }
            else {
                $reNewAccountId = $data[2];
                $price = $data[3];
                $serviceDetails = $this->serviceFunctions->getServiceDetails($serviceId);
                if (!$serviceDetails['result']) {
                    return;
                }
                $serviceDetailsText = $serviceDetails['text'];

                $this->botFunctions->sendMessage("✅ رسید پرداختت رسید! داریم چک می‌کنیم و زود نتیجه رو می‌گیم 🙏🏻", keyboardInput: remove);
                $admin = $this->dataBase->selectFromDB("admins", ["telegram_id"], "telegram_username='" . admin . "'")[0]['telegram_id'];
                $result = $this->botFunctions->forwardMessage($admin);

                $keyboard = [
                    'inline_keyboard' => [
                        [['text' => "تایید ✅", 'callback_data' => "order_response-confirm-$serviceId-" . chatId . "-$reNewAccountId"]],
                        [['text' => "رد ❌", 'callback_data' => "order_response-reject_buy-$serviceId-" . chatId . "-$reNewAccountId"]],
                        [['text' => "بلاک 🚫", 'callback_data' => "order_response-block-$serviceId-" . chatId . "-$reNewAccountId"]]
                    ]
                ];

                $this->botFunctions->sendMessage(
                    "🧾 جزئیات سفارش:\n" . $serviceDetailsText . "\n\n" .
                    "• مبلغ بعد از تخفیف: $price تومان",
                    id: $admin,
                    keyboardInput: $keyboard,
                    messageIdToReply: $result['result']['message_id'],
                    chatId: $admin
                );
            }
            $this->mainMenu();
        }
        // کد تخفیف برای خرید سرویس آماده
        else if (str_starts_with($step, "discountCode-")) {
            $data = explode("-", $step);
            $code = userText;
            $serviceId = $data[1];
            $accountId = $data[2] ?? "false";
            $result = $this->applyDiscountCode($code, $serviceId);

            if ($result['result']) {
                $this->botFunctions->sendMessage("🎉 کد تخفیفت اوکی شد! قیمت جدید: " . $result['price'] . " تومان 🤩");
                $oldNumber = $this->dataBase->selectFromDB("discount_codes", ["number"], "name='$code'")[0]['number'];
                $oldNumber--;
                $this->dataBase->updateToDB("discount_codes", ["number"], [$oldNumber], "name='$code'");
                $keyboard = $this->serviceFunctions->buyServiceKeyboard($serviceId, $accountId, $result['price']);
                $text = $this->serviceFunctions->getServiceDetails($serviceId);
                if (!$text['result']) {
                    return;
                }
                $text = $text['text'] . "\n\n" . "💰 قیمت بعد از تخفیف: " . $result['price'] . " تومان";
                $this->sentNewPanel($keyboard, $text);
                $this->botFunctions->setStep("home");
            } else {
                $this->botFunctions->sendMessage("😕 اووپس! این کد تخفیف درست نبود یا منقضی شده ❌\nاز منوی بالا انتخاب کن یا یه کد دیگه امتحان کن", messageIdToReply: $lastPanel);
            }
        }
        // کد تخفیف برای سرویس کاستوم (خرید جدید)
        else if (str_starts_with($step, "customServiceDiscountCode-")) {
            $data = explode("-", $step);
            $code = userText;
            $days = $data[1];
            $volume = $data[2];
            $multiLogin = $data[3];
            $sum = $data[4];
            $result = $this->applyDiscountCode($code, price: $sum, isCustom: TRUE);

            if ($result['result']) {
                $this->botFunctions->sendMessage("🎉 کدت اعمال شد! قیمت جدید: " . $result['price'] . " تومان 🤩");
                $oldNumber = $this->dataBase->selectFromDB("discount_codes", ["number"], "name='$code'")[0]['number'];
                $oldNumber--;
                $this->dataBase->updateToDB("discount_codes", ["number"], [$oldNumber], "name='$code'");
                $keyboard = $this->serviceFunctions->buyCustomServiceKeyboard($days, $volume, $multiLogin, $result['price']);
                $text = "💰 قیمت بعد از تخفیف: " . $result['price'] . " تومان";
                $this->sentNewPanel($keyboard, $text);
                $this->botFunctions->setStep("home");
            } else {
                $this->botFunctions->sendMessage("😕 این کد تخفیف کار نکرد یا اعتبارش تموم شده بود ❌\nاز منوی بالا ادامه بده", messageIdToReply: $lastPanel);
            }
        }
        // کد تخفیف برای «افزودن» به سرویس
        else if (str_starts_with($step, "addCustomServiceDiscountCode-")) {
            $data = explode("-", $step);
            $code = userText;
            $orderId = $data[1];
            $sum = $data[2];
            $result = $this->applyDiscountCode($code, price: $sum, isCustom: TRUE);

            if ($result['result']) {
                $this->botFunctions->sendMessage("🎉 تخفیف اعمال شد! قیمت جدید: " . $result['price'] . " تومان 😍");
                $oldNumber = $this->dataBase->selectFromDB("discount_codes", ["number"], "name='$code'")[0]['number'];
                $oldNumber--;
                $this->dataBase->updateToDB("discount_codes", ["number"], [$oldNumber], "name='$code'");
                $keyboard = $this->serviceFunctions->buyAddCustomServiceKeyboard($orderId, $result['price']);
                $text = "💰 قیمت بعد از تخفیف: " . $result['price'] . " تومان";
                $this->sentNewPanel($keyboard, $text);
                $this->botFunctions->setStep("home");
            } else {
                $this->botFunctions->sendMessage("😕 این کد تخفیف معتبر نبود یا تموم شده بود ❌\nاز منوی بالا ادامه بده", messageIdToReply: $lastPanel);
            }
        }
        // افزودن کاستوم (روز/حجم/مولتی)
        else if (str_starts_with($step, "AddCustomService-")) {
            $action = explode("-", $step)[1];
            $accountId = explode("-", $step)[2];

            if (!is_numeric(userText) or userText <= 0) {
                $this->botFunctions->sendMessage("😅 مقدار وارد شده درست نیست رفیق! باید یه عدد بزرگ‌تر از صفر باشه ✌️", messageIdToReply: $lastPanel);
                return;
            }

            $value = (int)userText;
            $orderId = $this->serviceFunctions->generateOrderId();
            $customService = $this->dataBase->selectFromDB("services", ["*"], "name='کاستوم'")[0];

            if ($action == "days") {
                $sum = $value * $customService['days_price'];
                $buyKeyboard = $this->serviceFunctions->buyAddCustomServiceKeyboard($orderId, $sum);
                $this->dataBase->insertToDB("orders", ["order_id", "telegram_id", "type", "data"], [$orderId, chatId, "addCustomService", "days-$value-$accountId"]);
            } else if ($action == "volume") {
                $sum = $value * $customService['volume_price'];
                $buyKeyboard = $this->serviceFunctions->buyAddCustomServiceKeyboard($orderId, $sum);
                $this->dataBase->insertToDB("orders", ["order_id", "telegram_id", "type", "data"], [$orderId, chatId, "addCustomService", "volume-$value-$accountId"]);
            } else if ($action == "multi") {
                $sum = $value * $customService['multi_price'];
                $buyKeyboard = $this->serviceFunctions->buyAddCustomServiceKeyboard($orderId, $sum);
                $this->dataBase->insertToDB("orders", ["order_id", "telegram_id", "type", "data"], [$orderId, chatId, "addCustomService", "multi-$value-$accountId"]);
            }

            $text = "🧾 مبلغ صورتحساب: " . $sum . " تومان";
            $text .= "\n\n⚡ اگر کد تخفیف داری همین الان بفرست؛ اگه نداری روش پرداختتو انتخاب کن ✨";
            $this->botFunctions->editMessage(messageId: $lastPanel, text: $text, keyboardInput: $buyKeyboard);
            $this->botFunctions->setStep("addCustomServiceDiscountCode-$orderId-$sum");
        }
        // خرید سرویس کاستوم (گام‌های روز و مولتی)
        else if (str_starts_with($step, "buyService-")) {
            $data = explode("-", $step);
            $action = $data[1];
            $days = $data[2] ?? 0;
            $volume = $data[3] ?? 0;
            $customService = $this->dataBase->selectFromDB("services", ["*"], "name='کاستوم'")[0];

            if ($action == "days") {
                if (!is_numeric(userText) or userText <= 0) {
                    $this->botFunctions->sendMessage("😅 عدد وارد شده درست نیست؛ باید بزرگ‌تر از صفر باشه ✌️", messageIdToReply: $lastPanel);
                    return;
                }
                $value = (int)userText;
                $this->sentNewPanel(backKeyboard, "👥 چندتا کاربر همزمان می‌خوای؟ حداقل 2 کاربر\n💡 قیمت نهایی = تعداد روز × تعداد کاربر");
                $this->botFunctions->setStep("buyService-multi-" . $value);
            }
            else if ($action == "multi") {
                $multiLogin = userText;
                if (!is_numeric(userText) or userText <= 0) {
                    $this->botFunctions->sendMessage("😅 مقدار وارد شده درست نیست ✌️", messageIdToReply: $lastPanel);
                    return;
                }
                if (!is_numeric(userText) or userText < 2) {
                    $this->botFunctions->sendMessage(" حداقل تعداد کاربر 2 عدد است ", messageIdToReply: $lastPanel);
                    return;
                }
                $sum = ($days * $customService['days_price']) * $multiLogin;

                $keyboard = $this->serviceFunctions->buyCustomServiceKeyboard($days, $volume, $multiLogin, $sum);
                $text = "🧾 مبلغ فاکتور: " . $sum . " تومان";
                $text .= "\n\n⚡ اگه کد تخفیف داری همین الان بفرست؛ اگه نداری روش پرداختتو انتخاب کن";
                $this->botFunctions->editMessage(messageId: $lastPanel, text: $text, keyboardInput: $keyboard);
                $this->botFunctions->setStep("customServiceDiscountCode-$days-$volume-$multiLogin-$sum");
            }
        }
        else if (str_starts_with($step, "userInfo-")) {
            $this->userInfo->handler($step);
        }

        // افزودن اکانت کاربر
        else if ($step == "addUserAccount") {
            if (!str_contains(userText, "\n")) {
                $this->botFunctions->sendMessage("⚠️ فرمت درست نیست! یوزر و پسورد رو هر کدوم تو یه خط جدا بفرست 🙏");
                $userAccounts = $this->accountFunctions->getUserAccounts();
                $response = $this->botFunctions->sendMessage(text: $userPanelText, parsMode: "MarkdownV2", keyboardInput: $userAccounts);
                $this->submitNewMenu($response);
                return;
            }
            $user = explode("\n", userText)[0];
            $pass = explode("\n", userText)[1];
            $userInfo = $this->IBSngHandlers->getUserInfoArray($user, TRUE);
            if (is_null($userInfo) or $pass != $userInfo['password']) {
                $this->botFunctions->sendMessage("❌ یوزر یا پسورد اشتباهه 😬 یه بار دیگه امتحان کن");
                $userAccounts = $this->accountFunctions->getUserAccounts();
                $response = $this->botFunctions->sendMessage(text: $userPanelText, parsMode: "MarkdownV2", keyboardInput: $userAccounts);
                $this->submitNewMenu($response);
                return;
            }
            $this->botFunctions->sendMessage("✅ اکانت با موفقیت اضافه شد! 🎉");
            $this->dataBase->insertToDB("user_accounts", ['telegram_id', 'account_username'], [userId, $user]);
            $userAccounts = $this->accountFunctions->getUserAccounts();
            $response = $this->botFunctions->sendMessage(text: $userPanelText, parsMode: "MarkdownV2", keyboardInput: $userAccounts);
            $this->submitNewMenu($response);
        }
        // پیام به ادمین
        else if ($step == "adminMessage") {
            $this->botFunctions->sendMessageToAdmins(userText);
            $this->botFunctions->sendMessage("✅ پیامت رفت برای مدیریت! به محض بررسی بهت خبر می‌دیم 🙌");
            $this->mainMenu(FALSE);
        }
        // نمایش منو
        else if (userText == "/menu") {
            $this->mainMenu(TRUE);
        }
        // پیش‌فرض
        else {
            $this->botFunctions->sendMessage("برای دیدن منو دستور /menu رو بفرست 😎");
        }
    }

    // ثبت پنل جدید کاربر
    public function submitNewMenu($response)
    {
        $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . userId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->botFunctions->deleteUserMessage($latestPanel, userId);
        }
        $this->dataBase->deleteFromDB("tmp", "name LIKE'" . userId . "-%'");
        $this->botFunctions->setStep("home");
        $this->dataBase->insertToDB("tmp", ["name", "value"], [userId . "-latestPanel", $response['result']['message_id']]);
    }

    // ارسال پنل جدید (با متن و کیبورد)
    private function sentNewPanel($panel, $text)
    {
        $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->botFunctions->deleteGroupMessage($latestPanel);
        }
        $this->dataBase->deleteFromDB("tmp", "name LIKE'" . chatId . "-%'");
        $response = $this->botFunctions->sendMessage(text: $text, id: chatId, keyboardInput: $panel);
        $this->dataBase->insertToDB("tmp", ["name", "value"], [chatId . "-latestPanel", $response['result']['message_id']]);
        $this->botFunctions->setStep("home");
    }

    // منوی اصلی
    public function mainMenu($delete = FALSE, $userId = chatId): void
    {
        if ($delete) {
            $this->botFunctions->deleteUserMessage(messageId);
        }
        $latestPanel = $this->dataBase->selectFromDB("tmp", ["value"], "name='" . $userId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->botFunctions->deleteUserMessage($latestPanel, $userId);
        }
        $this->botFunctions->setStep("home", $userId);
        $this->dataBase->deleteFromDB("tmp", "name LIKE'" . $userId . "-%'");
        $response = $this->botFunctions->sendMessage(text: $this->userStrings['mainMenu'], id: $userId, keyboardInput: userMainKeyboard);
        $this->dataBase->insertToDB("tmp", ["name", "value"], [$userId . "-latestPanel", $response['result']['message_id']]);
    }

    // اعمال کد تخفیف
    private function applyDiscountCode($code, $serviceId = 0, $price = 0, $isCustom = FALSE)
    {
        $details = $this->dataBase->selectFromDB("discount_codes", ["*"], "name='$code'") ?? "";
        if (empty($details)) {
            return ['result' => FALSE, 'error' => 'Code not found'];
        }
        $details = $details[0];
        if (time() > strtotime($details['expire_date'])) {
            return ['result' => FALSE, 'error' => 'Code is Expired'];
        }
        if ($details['number'] == 0) {
            return ['result' => FALSE, 'error' => 'Reached used limit'];
        }
        if ($details['group_type'] == "partners" and !$this->isPartner(userId)) {
            return ['result' => FALSE, 'error' => 'Just Partners'];
        }
        $type = $details['type'];
        if ($isCustom) {
            $servicePrice = $price;
        } else {
            $servicePrice = $this->serviceFunctions->getServiceDetails($serviceId)['array']['price'];
        }
        if ($type == "fixed") {
            $servicePrice -= $details['value'];
        } else if ($type == "percentage") {
            $servicePrice -= (($servicePrice * $details['value']) / 100);
        }
        return ['result' => TRUE, 'price' => $servicePrice];
    }

    public function isPartner($userId)
    {
        $partners = $this->dataBase->selectFromDB("partners", ["telegram_id"]);
        $partners = array_column($partners, "telegram_id");
        return in_array($userId, $partners);
    }
}
