<?php

use bot\generalClassBuilder\generalClassBuilder;
use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;
use bot\telegram\Telegram;

require __DIR__ . "/generalClassBuilder.php";

class broadcast
{
    private generalClassBuilder $generalClassBuilder;
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private Telegram $bot;
    private string $message;
    private array $notSentReasons;

    public function __construct()
    {
        $this->generalClassBuilder = new generalClassBuilder();
        $this->botFunctions = $this->generalClassBuilder->getGeneralFunctions();
        $this->dataBase = $this->generalClassBuilder->generalDBFunctions;
        $this->message = $this->dataBase->selectFromDB("broadcast",["message"])[0]['message'];
        if (isset($this->message))
        {
            $this->dataBase->deleteFromDB("broadcast","1");
            $this->notSentReasons = [];
            $this->doBroadcast();
        }
    }
//    public function __construct(string $message)
//    {
//        $this->generalClassBuilder = new generalClassBuilder();
//        $this->botFunctions = $this->generalClassBuilder->getGeneralFunctions();
//        $this->dataBase = $this->generalClassBuilder->generalDBFunctions;
//        $this->message = $message;
//        $this->notSentReasons = [];
//    }


    public function doBroadcast()
    {
        $this->addToReadyAll();
        $userIds = $this->dataBase->selectFromDB("ready", ["id"]);
//        $userIds = $this->loadUserIds();
        $userIdsCount = count($userIds);
        $fail = 0;
        $this->sendMessageToAdmins("شروع ارسال به " . $userIdsCount . " نفر");
        $this->sendMessageToAdmins($this->message);
        foreach ($userIds as $userId) {
            $response = $this->botFunctions->sendMessage(text: $this->message, id: $userId['id']);
//            $response = $this->botFunctions->sendMessage(text: $this->message, id: $userId);
            if (!$response["ok"]) {
                $fail++;
                $this->botFunctions->sendMessage($userId['id'],ADMIN['mahdi']);
                $this->addToReasons($response['description']);
            }
        }
        $reasonsText = "";
        foreach ($this->notSentReasons as $key => $value) {
            $reasonsText = $reasonsText . $key . " : " . $value . "\n";
        }
        $this->sendMessageToAdmins("موفق: " . count($userIds) - $fail);
        $this->sendMessageToAdmins("نا موفق: $fail");
        $this->sendMessageToAdmins("دلایل عدم ارسال : ");
        $this->sendMessageToAdmins($reasonsText);
        $this->sendMessageToAdmins("ارسال همگانی تمام شد");
    }

    public function addToReadyAll(): void
    {
        try {
            $stmt = db->prepare("TRUNCATE `ready`");
            $stmt->execute();
            $stmt = db->prepare("INSERT INTO ready (id)
                SELECT telegram_id FROM step;");
            $stmt->execute();
        } catch (PDOException $e) {
            // Handle exception or log
        }
    }

    public function sendMessageToAdmins(string $text)
    {
        $admins = $this->dataBase->selectFromDB("admins", ["telegram_id"]);
        foreach ($admins as $admin) {
            $this->botFunctions->sendMessage($text, id: $admin['telegram_id']);
        }
    }
    public function addToReasons($reason)
    {
        if (in_array($reason, array_keys($this->notSentReasons))) {
            $this->notSentReasons[$reason] = $this->notSentReasons[$reason] + 1;
        }
        else
        {
            $this->notSentReasons[$reason] = 1;
        }
        file_put_contents(__DIR__ . "/notSentReason.txt", json_encode($this->notSentReasons));
    }
    public function loadUserIds(): array
    {
        // Replace with your actual chat_id list
        $ids = [];
        for ($i = 1; $i <= 5; $i++) {
            if($i%3==0)
                $ids[] = ADMIN['mahdi'];
            else
                $ids[] = 7825703497+$i;
        }
        return $ids;
    }
}

//if (isset($argv[1])) {
//    $received = $argv[1];
//    $text = file_get_contents(__DIR__ . "/$received");
//    $x = new broadcast($text);
//    $x->doBroadcast();
//}
$x = new broadcast();
