<?php

namespace bot\generalFunctions;

use bot\generalDBFunctions\generalDBFunctions;
use bot\telegram\Telegram;
use bot\user\userBot\userBot;
use PDOException;

require_once __DIR__ . '/Telegram.php';
require_once __DIR__ . '/generalConfig.php';
require_once __DIR__ . '/generalDBFunctions.php';
require_once __DIR__ . '/generalKeyboard.php';


class generalFunctions
{
    private Telegram $bot;
    private generalDBFunctions $generalDBFunctions;

    public function __construct()
    {
        $this->generalDBFunctions = new generalDBFunctions();
        $this->bot = bot;
    }

    public function addStep(): void
    {
        $this->generalDBFunctions->insertToDB("step", ["telegram_id", "telegram_username", "telegram_full_name", "step"], [userId, telegramUserName, telegramFullName, "home"]);
        $this->generalDBFunctions->insertToDB("users_profile", ["telegram_id", "level", "phone", "expire_time"], [userId, 0, 0, date("Y-m-d", time() + (3600 * 24 * 360))]);
        $this->generalDBFunctions->insertToDB("users_balance",["telegram_id"],[userId]);
    }

    public function setStep(string $step, string $chatId = userId): void
    {
        $this->generalDBFunctions->updateToDB("step", ["step"], ["$step"], "telegram_id='" . $chatId . "'");
    }

    public function getStep()
    {
        return $this->generalDBFunctions->selectFromDB("step", ["*"], "telegram_id='" . userId . "'")[0]['step'];
    }

    public function getIdFromFullName($fullName)
    {
        return $this->generalDBFunctions->selectFromDB("step", ["telegram_id"], "telegram_full_name='" . $fullName . "'")[0]['telegram_id'];
    }

    public function isAdmin(): bool
    {
        $admins = $this->generalDBFunctions->selectFromDB("admins", ["telegram_id"]);
        foreach ($admins as $admin) {
            if ($admin['telegram_id'] == userId or $admin['telegram_id'] == chatId) {
                return TRUE;
            }
        }
        return FALSE;
    }

    public function addToReadyAll(): void
    {
        try {
            $stmt = db->prepare("TRUNCATE `ready`");
            $stmt->execute();
            $stmt = db->prepare("INSERT INTO ready (id)
                SELECT telegram_id FROM step;");
            $stmt->execute();
        } catch (PDOException $e) {
            // Handle exception or log
        }
    }

    public function isNewUser(): bool
    {
        $rows = $this->generalDBFunctions->selectFromDB('step', ['*'], "telegram_id='" . userId . "'");
        return (empty($rows));
    }

    public function phoneRegistered(): bool
    {
        $rows = $this->generalDBFunctions->selectFromDB('step', ['phone'], "telegram_id='" . userId . "'")[0]['phone'];
        return (!is_null($rows));
    }

    public function requestPhone(): void
    {
        $this->sendMessage("از طریق دکمه زیر لطفا شماره موبایل خود را ارسال کنید", keyboardInput: getPhone);
    }

    public function addPhone(): void
    {
        if (str_starts_with(userPhoneNumber, "+98") or str_starts_with(userPhoneNumber, "98") or TRUE) {
            if (str_starts_with(userPhoneNumber, "+98")) {
                $phone = preg_replace('/\+98/', '0', userPhoneNumber);
            }
            else {
                $phone = preg_replace('/98/', '0', userPhoneNumber);;
            }
            $this->generalDBFunctions->updateToDB("step", ["phone"], [$phone], "telegram_id='" . userId . "'");
            $this->sendMessage("با تشکر از شما", keyboardInput: remove);
        }
        else {
            $this->sendMessage("ثبت نام فقط با شماره ایران ممکن است");
        }
    }

    public function isVerified($userPhone): bool
    {
        $status = $this->generalDBFunctions->selectFromDB("verify", ['status'], "phone='" . $userPhone . "'")[0]['status'];
        if ($status == "1") {
            return TRUE;
        }
        else {
            return FALSE;
        }
    }

    public function getFile(): array
    {
        $data = $this->detectType();

        $fileId = $data['id'];
        $fileType = $data['type'];
        $fileName = $data['name'] ?? null;

        $file = $this->bot->getFile($fileId);
        $path = $file['result']['file_path'];
        $path = ltrim($path, '/'); // remove leading slash

        $parts = explode('/', $path);
        $parts = array_filter($parts); // remove empty elements
        $parts = array_values($parts);


        $fileName = is_null($fileName) ? $parts[1] : $fileName;
        $folder   = $parts[0];
        if (!is_dir($folder)) {
            mkdir($folder, 0755, TRUE);
        }

        $this->bot->downloadFile($file['result']['file_path'], $folder."/".$fileName);
        return ['link' => $folder."/".$fileName, 'type' => $fileType,'name'=>$fileName];
    }

    function broadcast($forwardMessageId = ""): void
    {
        if ($forwardMessageId != "") {
            $forward = TRUE;
            $messageId = $forwardMessageId;
        }
        else {
            $forward = FALSE;
            $messageId = messageId;
        }
        $this->addToReadyAll();
//        $userIds = $this->generalDBFunctions->selectFromDB("ready", ["id"]);
        $userIds[] = 7825703497;
        $fail = 0;
        $userIdsCount = count($userIds);
        $this->sendMessage("شروع ارسال به " . $userIdsCount . " نفر");

        $data = data['message'];

        if (updateType == "message" and !(isset($data['caption_entities']) || isset($data['entities']) || $forward)) {

            foreach ($userIds as $userId) {
                try {
                    $response = $this->sendMessage(userText,$userId['id']);
                    if ($response['ok'] != "true") {
                        $fail++;
                    }

                } catch (PDOException $e) {
                }
            }
        }
        if (isset($data['caption_entities']) || isset($data['entities']) || $forward) {
            foreach ($userIds as $userId) {
                try {
                    $response = bot->forwardMessage(
                        [
                            'chat_id' => $userId['id'],
                            'from_chat_id' => chatId,
                            'message_id' => $messageId
                        ]
                    );
                    if ($response['ok'] != "true") {
                        $fail++;
                        $this->sendMessage($fail,id:ADMIN['mahdi']);
                    }
                } catch (PDOException $e) {
                }
            }
        }
        else if (updateType != "message") {
            $response = $this->detectType();
            $type = $response['type'];
            $fileId = $response['id'];

            foreach ($userIds as $userId) {
                try {
                    $response = $this->sendMedia(type: $type, media: $fileId, caption: mediaCaption, chatId: $userId['id']);
                    if ($response['ok'] != "true") {
                        $fail++;
                    }

                } catch (PDOException $e) {
                }
            }
        }
        $this->sendMessage("موفق: " . count($userIds) - $fail);
        $this->sendMessage("نا موفق: $fail");
        $this->sendMessage("ارسال همگانی تمام شد");
    }
    public function executeBroadcastFile($message = userText)
    {
        $file = __DIR__ . "/broadcast.php";
        $this->generalDBFunctions->insertToDB("broadcast",["message"],[$message]);
//        file_put_contents(__DIR__ . "/tmp.txt", $message);
        exec("php $file", $output);
    }
    function broadcastMessage($userId,$forward,$messageId,$fail)
    {
        $data = data['message'];
        if (updateType == "message" and !(isset($data['caption_entities']) || isset($data['entities']) || $forward)) {
            try {
                $response = $this->sendMessage(userText, $userId);
                if ($response['ok'] != "true") {
                    $fail++;
                }

            } catch (PDOException $e) {
            }
        }
        if (isset($data['caption_entities']) || isset($data['entities']) || $forward) {
            try {
                $response = bot->forwardMessage(
                    [
                        'chat_id' => $userId,
                        'from_chat_id' => chatId,
                        'message_id' => $messageId
                    ]
                );
                if ($response['ok'] != "true") {
                    $fail++;
                }
            } catch (PDOException $e) {
            }
        }
        else if (updateType != "message") {
            $response = $this->detectType();
            $type = $response['type'];
            $fileId = $response['id'];

            try {
                $response = $this->sendMedia(type: $type, media: $fileId, caption: mediaCaption, chatId: $userId);
                if ($response['ok'] != "true") {
                    $fail++;
                }

            } catch (PDOException $e) {
            }
        }
        return $fail;
    }

    public function detectType()
    {
        $type = updateType;
        if ($type === "photo") {
            return ['type' => 'photo', 'id' => photoId];
        }
        else if ($type === "voice") {
            return ['type' => 'voice', 'id' => voiceId];
        }
        else if ($type === "document") {
            return ['type' => 'document', 'id' => documentId, 'name' => data['message']['document']['file_name']];
        }
        else if ($type === "animation") {
            return ['type' => 'animation', 'id' => animationId];
        }
        else if ($type === "video") {
            return ['type' => 'video', 'id' => videoId];
        }
        else if ($type === "audio") {
            return ['type' => 'audio', 'id' => audioId , 'name' => data['message']['audio']['file_name']];
        }
    }

    public function deleteUserMessage($messageId, $chatId = userId)
    {
        return $this->bot->deleteMessage(
            [
                'chat_id' => $chatId,
                'message_id' => $messageId
            ]
        );
    }

    public function deleteGroupMessage(int $id, $chatId = chatId)
    {
        return $this->bot->deleteMessage(
            [
                'chat_id' => $chatId,
                'message_id' => $id
            ]
        );
    }


    public function sendMessage(string $text, string $id = "", array $keyboardInput = NULL, $messageIdToReply = NULL, $chatId = NULL,$parsMode = NULL): mixed
    {
        $reply = NULL;
        if ($id == "") {
            if (messageFromGroup or messageFromChannel) {
                $id = chatId;
            }
            else {
                $id = userId;
            }
        }
        if (is_null($chatId)) {
            $chatId = $id;
        }
        if (!is_null($messageIdToReply)) {
            $reply = json_encode([
                    'message_id' => $messageIdToReply,
                    'chat_id' => $chatId
                ]
            );
        }
        if ($keyboardInput != NULL) {
            $keyboardInput = json_encode($keyboardInput);
        }
        return $this->bot->sendMessage(
            [
                'chat_id' => $id,
                'text' => $text,
                'reply_markup' => $keyboardInput,
                'reply_parameters' => $reply,
                'parse_mode' => $parsMode
            ]
        );
    }

    public function sendMedia(string $type, mixed $media, string $caption = "", string $chatId = "", $replyMarkup = NULL): mixed
    {
        if ($chatId == "") {
            if (messageFromGroup) {
                $chatId = chatId;
            }
            else {
                $chatId = userId;
            }
        }
        if (!is_null($replyMarkup)) {
            $replyMarkup = json_encode($replyMarkup);
        }
        switch ($type) {
            case "photo":
                return $this->bot->sendPhoto(
                    [
                        'chat_id' => $chatId,
                        'photo' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            case "voice":
                return $this->bot->sendVoice(
                    [
                        'chat_id' => $chatId,
                        'voice' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            case "document":
                return $this->bot->sendDocument(
                    [
                        'chat_id' => $chatId,
                        'document' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            case "animation":
                return $this->bot->sendAnimation(
                    [
                        'chat_id' => $chatId,
                        'animation' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            case "video":
                return $this->bot->sendVideo(
                    [
                        'chat_id' => $chatId,
                        'video' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            case "audio":
                return $this->bot->sendAudio(
                    [
                        'chat_id' => $chatId,
                        'audio' => $media,
                        'caption' => $caption,
                        'reply_markup' => $replyMarkup
                    ]
                );
            default:
                return "done";
        }
    }
    public function editMessageMedia(string $type = NULL, mixed $media = NULL ,$parsMode = NULL, string $caption = "",string $messageId = messageId, string $chatId = "", $keyboardInput = NULL)
    {
        if ($chatId == "") {
            if (messageFromGroup) {
                $chatId = chatId;
            }
            else {
                $chatId = userId;
            }
        }
        if (is_null($media))
        {
            return $this->bot->editMessageMedia(
                [
                    'chat_id' => $chatId,
                    'message_id' => $messageId,
                    'reply_markup' => json_encode($keyboardInput),
                    'parse_mode' => $parsMode,
                ]
            );

        }
        else
        {
            return $this->bot->editMessageMedia(
                [
                    'chat_id' => $chatId,
                    'message_id' => $messageId,
                    'reply_markup' => json_encode($keyboardInput),
                    'parse_mode' => $parsMode,
                    'media' => json_encode([
                        'media' => 'attach://file',
                        'type' => $type,
                        'caption' => $caption
                    ]),
                    'file' => $media,
                ]
            );
        }
    }

    public function editMessage(string $chatId = "", string $messageId = messageId, string $text = "", array $keyboardInput = [], $parsMode = NULL)
    {
        if ($chatId == "") {
            if (messageFromGroup) {
                $chatId = chatId;
            }
            else {
                $chatId = userId;
            }
        }
        $data = [
            'chat_id' => $chatId,
            'message_id' => $messageId,
            'text' => $text,
            'parse_mode' => $parsMode,
        ];
        if ($text == "") {
            if (!empty($keyboardInput)) {
                $data['reply_markup'] = json_encode($keyboardInput);
            }
            return $this->bot->editMessageReplyMarkup($data);
        }
        else {
            if (!empty($keyboardInput)) {
            $data['reply_markup'] = json_encode($keyboardInput);
            }
            if (!empty($parseMode)) {
                $data['parse_mode'] = $parseMode;
            }

            return $this->bot->editMessageText($data);
        }
    }

    public function sendToAdmin($msgId): void
    {
        $this->forwardMessage(toChatId: ADMIN['mahdi'], messageId: $msgId);
    }

    public function forwardMessage($toChatId, $messageId = messageId, $fromChatId = userId)
    {
        return $this->bot->forwardMessage(
            [
                'chat_id' => $toChatId,
                'from_chat_id' => $fromChatId,
                'message_id' => $messageId
            ]
        );
    }
    public function copyMessage($toChatId, $messageId = messageId, $fromChatId = userId)
    {
        return $this->bot->copyMessage(
            [
                'chat_id' => $toChatId,
                'from_chat_id' => $fromChatId,
                'message_id' => $messageId
            ]
        );
    }

    public function isBlackList($userId): bool
    {
        $data = $this->generalDBFunctions->selectFromDB("black_list", ["telegram_id"], "telegram_id='$userId'");
        if (empty($data)) {
            return FALSE;
        }
        else {
            return TRUE;
        }
    }

    public function addBlackList($userId, $username): void
    {
        $this->generalDBFunctions->insertToDB("black_list", ['telegram_id', 'telegram_username'], [$userId, $username]);
    }

    public function removeBlackList($userId): void
    {
        $this->generalDBFunctions->deleteFromDB("black_list", "telegram_id='" . $userId . "'");
    }

    public function createChatInviteLink($channelId, $hour = 3)
    {
        $seconds = $hour * 3600;
        return $this->bot->createChatInviteLink(
            [
                'chat_id' => $channelId,
                'name' => telegramUserName,
                'expire_date' => time() + $seconds,
                'member_limit' => 1
            ])['result']['invite_link'];
    }

    public function isUserInChannel($channelId, $userId)
    {
        return $this->bot->getChatMember(
            [
                'chat_id' => $channelId,
                'user_id' => $userId
            ]
        )['result']['status'];
    }

    public function unbanChatMember($channelId, $userId): void
    {
        $this->bot->unbanChatMember(
            [
                'chat_id' => $channelId,
                'user_id' => $userId,
            ]
        );
    }

    public function kickChatMember($channelId, $userId)
    {
        return $this->bot->kickChatMember(
            [
                'chat_id' => $channelId,
                'user_id' => $userId,
            ]
        );
    }

    public function sendMessageToAdmins(string $text, string $parsMode=NULL)
    {
        $admins = $this->generalDBFunctions->selectFromDB("admins", ["telegram_id"]);
        foreach ($admins as $admin) {
            $this->sendMessage($text, id: $admin['telegram_id'],parsMode: $parsMode);
        }
    }
    public function forwardMessageToAdmins(string $text)
    {
        $admins = $this->generalDBFunctions->selectFromDB("admins", ["telegram_id"]);
        foreach ($admins as $admin) {
            $this->forwardMessage(toChatId: $admin['telegram_id'],messageId: messageId,fromChatId: userId);
        }
    }


    public function isBotActive()
    {
        $status = $this->generalDBFunctions->selectFromDB("settings", ["value"], "name='وضعیت ربات'")[0]['value'];
        if ($status == "0") {
            return FALSE;
        }
        return TRUE;
    }

    public function isStoreActive()
    {
        $status = $this->generalDBFunctions->selectFromDB("settings", ["value"], "name='وضعیت فروشگاه'")[0]['value'];
        if ($status == "0") {
            return FALSE;
        }
        return TRUE;
    }

    public function createBackKeyboard($callback, $text = 'بازگشت⬅️')
    {
        return [
            'inline_keyboard' =>
                [
                    [
                        ['text' => $text, 'callback_data' => $callback],
                    ],
                ]
        ];
    }

    public function sendNewMenu($menu, $text): void
    {
        $latestPanel = $this->generalDBFunctions->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
        if ($latestPanel != NULL) {
            $this->deleteGroupMessage($latestPanel);
        }
        $this->generalDBFunctions->deleteFromDB("tmp", "name LIKE'" . chatId . "-%'");
        $response = $this->sendMessage(text: $text, id: chatId, keyboardInput: $menu);
        $this->generalDBFunctions->insertToDB("tmp", ["name", "value"], [chatId . "-latestPanel", $response['result']['message_id']]);
    }


    public function addBackAndChunk($keyboard, $chunk,$backKeyboard = back)
    {
        $keyboard[] = $backKeyboard;
        $keyboard = array_chunk($keyboard, $chunk);
        return ['inline_keyboard' => $keyboard];
    }

    public function getMenuMessageId()
    {
        return
            $this->generalDBFunctions->selectFromDB("tmp", ["value"], "name='" . chatId . "-latestPanel'")[0]['value'] ?? NULL;
    }
    public function updateMenuMessageId($messageId)
    {
        $this->generalDBFunctions->updateToDB("tmp",["value"],[$messageId],"name='" . chatId . "-latestPanel'");
    }
    public function getWelcomeMessage()
    {
        return $this->generalDBFunctions->selectFromDB("settings",["value"],"name='متن منو'")[0]['value'] ?? "خوش آمدید";
    }
    public function answerCallbackQuery($callbackQueryId,$text = "")
    {
        if ($text == "") {
            return $this->bot->answerCallbackQuery(
                [
                    'callback_query_id' => callback_id
                ]
            );
        }
        else
        {
            return $this->bot->answerCallbackQuery(
                [
                    'callback_query_id' => callback_id,
                    'text' => $text,
                ]
            );
        }
    }
    public function acceptedRules($accepted = FALSE)
    {
        if ($accepted) {
            $this->generalDBFunctions->insertToDB("rules",["telegram_id"],[userId]);
            return TRUE;
        }
        $acceptedRules = $this->generalDBFunctions->selectFromDB("rules",["telegram_id"]);
        $acceptedRules = array_column($acceptedRules, "telegram_id");
        return in_array(userId, $acceptedRules);
    }

    public function askRules()
    {
        $rule = $this->generalDBFunctions->selectFromDB("settings",["value"],"name='قوانین'")[0]['value'];
        $keyboard = [
            'inline_keyboard' =>
                [
                    [
                        ['text' => 'قبول میکنم ✅' , 'callback_data' => 'acceptRules'],
                    ]
                ]
        ];
        $this->sendMessage($rule,keyboardInput: $keyboard);
    }

    public function getUSDTPrice()
    {
        $url = 'https://api.nobitex.ir/market/stats?srcCurrency=usdt&dstCurrency=rls';

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 10,
        ]);

        $response = curl_exec($ch);
        curl_close($ch);

        if ($response === false) {
            return null; // or handle error
        }

        $data = json_decode($response, true);

        if (isset($data['stats']['usdt-rls']['latest'])) {
            return (float) $data['stats']['usdt-rls']['latest']/10;
        }

        return null; // if price not found

    }
}