<?php

require_once __DIR__ . '/IBSngRequests.php';

class IBSngHandlers
{
    private IBSngRequests $IBSngRequests;

    /**
     * @throws Exception
     */
    public function __construct($connection)
    {
        $x = microtime(true);
        $this->IBSngRequests = new IBSngRequests($connection);
        echo "1 : " . microtime(true) - $x . "<br>";


    }

    public function getGroupsNameList()
    {
        return $this->IBSngRequests->getGroupsName();
    }

    public function getGroupDetail($groupName = "")
    {
        $response = $this->IBSngRequests->getGroupsDetails($groupName);
        return $response;
        if ($groupName != "") {
            if (!$response['status']) {
                return ['result' => FALSE, 'error' => "Group not found"];
            }
        }
        return ['result' => TRUE, 'data' => $response];
    }

    public function newUser($user, $password, $groupName, $credit, $multiLogin = NULL)
    {
        return $this->IBSngRequests->addUser($user, $password, $groupName, $credit, $multiLogin);
    }

    public function getUserInfo($userName)
    {
        $response = $this->IBSngRequests->getUser($userName);
        if ($response['result']) {
            $info = "";
            foreach ($response['info'] as $key => $value) {
                $info = $info . "$key : $value\n";
            }
            return ['result' => TRUE, 'info' => $info];
        }
        else {
            return ['result' => FALSE];
        }
    }

    public function getUserInfoArray($userName, $withPassword = FALSE)
    {
        return $this->IBSngRequests->getUser($userName, $withPassword)['info'];
    }

    public function deleteUser($userName)
    {
        $response = $this->IBSngRequests->deleteUser($userName);
        if ($response['result']) {
            return ["result" => TRUE];
        }
        else {
            return $response;
        }
    }

    public function resetFirstLogin($userName)
    {
        return $this->IBSngRequests->resetFirstLogin($userName);
    }

    public function reNewUser($userName, $serviceDetails, $type = "", $customDays = 0)
    {
        return $this->IBSngRequests->reNewUser($userName, $serviceDetails, $type, $customDays);
    }

    /**
     * Input users must be an array of add data just like addUser() Method
     * ['user'=> $user, 'password' => $password, 'groupName' => $groupName, 'credit' => $credit, 'multiLogin' => $multiLogin = NULL]
     */
    public function addBatchUsers(array $users)
    {
        foreach ($users as $user) {
            if (!isset($user['user'])) {
                return ['result' => FALSE, 'error' => "at least one userName is missed!"];
            }

        }
        $result = [];
        foreach ($users as $user) {
            if (!$user['user'] ||
                !$user['password'] ||
                !$user['groupName'] ||
                !$user['credit']
            ) {
                $result[] = [$user['user'] => FALSE, 'error' => "Data is not completed!"];
            }
            else {
                $response = $this->IBSngRequests->addUser($user['user'], $user['password'], $user['groupName'], $user['credit'], $user['multiLogin']);
                if ($response['result']) {
                    $result[] = [$user['user'] => TRUE, 'message' => "Added!"];
                }
                else {
                    $result[] = [$user['user'] => FALSE, 'error' => $response['error']];
                }
            }
        }
        return $result;
    }

    public function editUser($userName, $attribute, $value, $userPasswordEdit = "")
    {
        return $this->IBSngRequests->editUser($userName, $attribute, $value, $userPasswordEdit);
    }

    public function checkStatus()
    {
        return $this->IBSngRequests->isConnected();
    }

    public function getAllUsersList()
    {
        return $this->IBSngRequests->getAllUsersList();
    }

    public function changeCredit($userId, $credit, $comment = "")
    {
        return $this->IBSngRequests->changeCredit($userId, $credit, $comment);
    }
    public function addDays($userName,$days)
    {
        return $this->IBSngRequests->addDays($userName,$days);
    }
    public function addMultiLogin($userName,$multiLogin)
    {
        return $this->IBSngRequests->addMultiLogin($userName,$multiLogin);
    }
}