<?php

class IBSngUtils
{
    public function extractHtmlSection($html, $start, $end)
    {
        $pos1 = strpos($html, $start);
        $pos2 = strpos($html, $end);
        return substr($html, $pos1, $pos2 - $pos1);
    }

    public function extractGroupNames($groupsList)
    {
        $doc = new DOMDocument();
        libxml_use_internal_errors(true);
        $doc->loadHTML($groupsList);
        libxml_clear_errors();
        $xpath = new DOMXPath($doc);
        $rows = $xpath->query("//tr[@class='List_Row_lightColor' or @class='List_Row_darkColor']/td[@class='list_col'][3]");

        $groupNames = [];
        foreach ($rows as $td) {
            $groupNames[] = trim($td->textContent);
        }
        return $groupNames;
    }

    public function preparePostDataForGroup($group)
    {
        return [
            'group_name' => $group,
            'edit_group' => '1',
            'attr_edit_checkbox_0' => 'group_info',
            'attr_edit_checkbox_3' => 'rel_exp_date',
            'attr_edit_checkbox_6' => 'multi_login',
            'tab1_selected' => 'Exp_Dates'
        ];
    }

    public function parseGroupDetails($html)
    {
        $dom = new DOMDocument();
        libxml_use_internal_errors(TRUE);
        $dom->loadHTML($html);
        libxml_clear_errors();
        $xpath = new DOMXPath($dom);

        $groupId = $this->getNodeText($xpath, "//td[contains(text(), 'Group ID')]/following-sibling::td");
        $groupName = $this->getNodeAttribute($xpath, "//input[@name='group_name']", 'value');
        $multiLoginValue = $this->getCheckedValue($xpath, "//input[@name='has_multi_login']", "//input[@name='multi_login']", 'value');
        $relExpCombined = $this->getRelExpCombined($xpath);

        $multiLoginValue = $multiLoginValue == "" ? NULL : $multiLoginValue;
        $relExpCombined = $relExpCombined == " " ? NULL : $relExpCombined;


        return [
            'group_id' => $groupId,
            'group_name' => $groupName,
            'multi_login_value' => $multiLoginValue,
            'rel_exp_combined' => $relExpCombined,
        ];
    }

    public function getNodeText($xpath, $query)
    {
        $node = $xpath->query($query);
        return $node->length > 0 ? trim($node->item(0)->textContent) : NULL;
    }

    public function getNodeAttribute($xpath, $query, $attribute)
    {
        $node = $xpath->query($query);
        return $node->length > 0 ? trim($node->item(0)->getAttribute($attribute)) : NULL;
    }

    public function getCheckedValue($xpath, $checkQuery, $valueQuery, $attribute)
    {
        $checked = $xpath->query($checkQuery)->length > 0;
        if ($checked) {
            return $this->getNodeAttribute($xpath, $valueQuery, $attribute);
        }
        return NULL;
    }

    public function getRelExpCombined($xpath)
    {
        $hasRelExp = $xpath->query("//input[@name='has_rel_exp']")->length > 0;
        if ($hasRelExp) {
            $relExpDate = $this->getNodeAttribute($xpath, "//input[@name='rel_exp_date']", 'value');
            $relExpUnit = $this->getNodeAttribute($xpath, "//select[@name='rel_exp_date_unit']/option[@selected='selected']", 'value');
            return $relExpDate . ' ' . $relExpUnit;
        }
        return NULL;
    }

    public function extractBetween($string, $start, $delimiter1, $delimiter2 = '"'): string
    {
        $pos1 = strpos($string, $start);
        if ($pos1 === FALSE) return '0';
        $trim1 = substr($string, $pos1 + strlen($start));
        $pos2 = strpos($trim1, $delimiter1);
        $trim2 = substr($trim1, $pos2 + strlen($delimiter1));
        $pos3 = strpos($trim2, $delimiter2);
        return trim(substr($trim2, 0, $pos3));
    }

    public function calculateRelativeExpireDate($text)
    {
        $number = explode(" ", $text)[0];
        $expireType = explode(" ", $text)[1];
        $days = 0;
        if (str_contains($expireType, 'Days')) {
            $days = $number * 1;
        }
        else if (str_contains($expireType, 'Months')) {
            $days = $number * 31;
        }
        else if (str_contains($expireType, 'Years')) {
            $days = $number * 365;
        }
        return $days;
    }

    public function validateUserName($userName): bool
    {
        if (preg_match('/^[a-zA-Z0-9]+$/', $userName)) {
            return TRUE;
        }
        else {
            return FALSE;
        }
    }
    /**
     * post data used for any function which want to do any update for user expire time
     */
    public function relativeExpireDatePost($userId, $days)
    {
        $post_data = $this->userTargetPostData($userId);
        $post_data['edit_tpl_cs'] = 'rel_exp_date';
        $post_data['tab1_selected'] = 'Exp_Dates';
        $post_data['attr_update_method_0'] = 'relExpDate';
        $post_data['has_rel_exp'] = 't';
        $post_data['rel_exp_date'] = $days;
        $post_data['rel_exp_date_unit'] = "Days";
        return $post_data;
    }

    /**
     * post data used for any function which want to do any update for user
     * Like chargeUser or edit user or create new user or anything related to update user
     */
    public function userTargetPostData($userId)
    {

        return ['target' => 'user',
            'target_id' => $userId,
            'update' => 1];
    }

    /**
     * post data for any function which need to do any job related to username or password of user
     * Like create new user with new user or password or update user or password
     */
    public function updateUserPasswordPostData($newUserName , $password, $oldUsername = "")
    {
        return [
            'edit_tpl_cs' => 'normal_username',
            'attr_update_method_0' => 'normalAttrs',
            'has_normal_username' => 't',
            'current_normal_username' => $oldUsername,
            'normal_username' => $newUserName,
            'password' => $password,
        ];
    }
    public function updateUserMultiLogin($multiLogin)
    {
        return [
            'edit_tpl_cs' => 'multi_login',
            'tab1_selected' => 'Multi_Login',
            'attr_update_method_0' => 'multiLogin',
            'has_multi_login' => 't',
            'multi_login' => $multiLogin
        ];
    }
    public function updateUserGroupPostData($groupName)
    {
        return [
            'edit_tpl_cs' => 'group_name',
            'tab1_selected' => 'Main',
            'attr_update_method_0' => 'groupName',
            'group_name' => $groupName
        ];
    }

}