<?php

namespace bot\admin\serviceFunctions;

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;
use bot\admin\adminIbsng\adminIbsng;

require_once __DIR__ . '/../generalFunctions.php';
require_once __DIR__ . '/../ibsng/IBSngHandlers.php';
require_once __DIR__ . '/adminIbsng.php';

class serviceFunctions
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    private adminIbsng $adminIbsng;

    public function __construct($generalFunctions, $generalDBFunctions, $IBSngHandlers)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
        $this->IBSngHandlers = $IBSngHandlers;
    }

    public function getServicesList($isEdit = FALSE, $action = "addUser-"): array
    {
        $list = $this->dataBase->selectFromDB("services", ["*"]);
        $keyboard = [];
        if ($isEdit) {
            foreach ($list as $service) {
                $keyboard[] = ["text" => $service["name"], "callback_data" => 'editService-' . $service["id"]];
            }
            $keyboard[] = ['text' => 'افزودن سرویس جدید➕', 'callback_data' => 'addService'];
        }
        else {
            foreach ($list as $service) {
                if ($service['status'] != "0" and !is_null($service['ibsng_group_name']) and !empty($service['ibsng_group_name'])) {
                    $keyboard[] = ["text" => $service["name"], "callback_data" => $action . $service["id"]];
                }
            }
        }
        $keyboard[] = back;
        $final = array_chunk($keyboard, 1);
        return [
            'inline_keyboard' => $final
        ];
    }

    public function changeServiceStatus($serviceId): void
    {
        $status = $this->dataBase->selectFromDB("services", ["status"], "id='$serviceId'")[0]['status'];
        $newStatus = 1;
        if ($status == "1") {
            $newStatus = 0;
        }
        $this->dataBase->updateToDB("services", ["status"], [$newStatus], "id='$serviceId'");
    }

    public function getServiceDetails($serviceId, $sentKeyboard = TRUE): array
    {
        $serviceDetails = $this->dataBase->selectFromDB("services", ["*"], "id='$serviceId'")[0];
        $custom = FALSE;
        $serviceName = $serviceDetails['name'];
        $serviceGroup = $serviceDetails['ibsng_group_name'] ?? "ندارد";
        $serviceStatus = $serviceDetails['status'] == 0 ? "غیرفعال 🔴" : "فعال 🟢";
        if ($serviceName == "کاستوم") {
            $custom = TRUE;
            $daysPrice = $serviceDetails['days_price'] ?? 0;
            $volumePrice = $serviceDetails['volume_price'] ?? 0;
            $multiPrice = $serviceDetails['multi_price'] ?? 0;
        }
        else {
            $servicePrice = $serviceDetails['price'] ?? 0;
            $serviceRechargePrice = $serviceDetails['recharge_price'] ?? 0;
            $servicePartnersPrice = $serviceDetails['partners_price'] ?? 0;
            $serviceCredit = $serviceDetails['credit'] ?? 0;
            $serviceMultiLogin = $serviceDetails['multi_login'] ?? "از گروه";
        }
        if ($sentKeyboard) {
            $keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => 'تغییر نام ✏️', 'callback_data' => 'editSelectedService-name-' . $serviceId],
                        ['text' => 'تغییر گروه 👥', 'callback_data' => 'editSelectedService-ibsng_group_name-' . $serviceId],
                    ],
                    [
                        ['text' => $custom ? "تغییر قیمت به ازای روز 🗓" : 'تغییر قیمت 💰', 'callback_data' => 'editSelectedService-' . ($custom ? "days_price-" . $serviceId : "price-" . $serviceId)],
                        ['text' => $custom ? "تغییر قیمت به ازای حجم 🌐" : 'تغییر قیمت همکار 🤝', 'callback_data' => 'editSelectedService-' . ($custom ? "volume_price-" . $serviceId : "partners_price-" . $serviceId)],
                    ],
                    [
                        ['text' => $custom ? "تغییر قیمت به ازای تعداد کاربر 🙋🏻‍♂️" : 'تغییر تعداد کاربر 🔒', 'callback_data' => 'editSelectedService-' . ($custom ? "multi_price-" . $serviceId : "multi_login-" . $serviceId)],
                        ['text' => $custom ? "" : 'تغییر قیمت تمدید ♻️', 'callback_data' => 'editSelectedService-recharge_price-' . $serviceId],
                    ],
                    [
                        ['text' => 'تغییر وضعیت سرویس 📊', 'callback_data' => 'editSelectedService-status-' . $serviceId],
                        ['text' => 'حذف سرویس 🗑️', 'callback_data' => 'editSelectedService-remove-' . $serviceId],
                    ],
                    [
                        ['text' => 'بازگشت⬅️', 'callback_data' => 'back'],
                    ]
                ]
            ];
            if ($custom) {
                $text = "مشخصات سرویس انتخابی:"
                    . "\n\n" . "1️⃣ نام : " . $serviceName
                    . "\n\n" . "2️⃣ گروه : " . $serviceGroup
                    . "\n\n" . "3️⃣ قیمت به ازای روز : " . $daysPrice . " تومان"
                    . "\n\n" . "4️⃣ قیمت به ازای حجم : " . $volumePrice . " تومان"
                    . "\n\n" . "5️⃣ قیمت به ازای تعداد کاربر : " . $multiPrice . " تومان"
                    . "\n\n" . "6️⃣ وضعیت : " . $serviceStatus;
            }
            else {
                $text = "مشخصات سرویس انتخابی:" .
                    "\n\n" . "1️⃣ نام : " . $serviceName
                    . "\n\n" . "2️⃣ گروه : " . $serviceGroup
                    . "\n\n" . "3️⃣ قیمت : " . $servicePrice
                    . "\n\n" . "4️⃣ قیمت تمدید : " . $serviceRechargePrice
                    . "\n\n" . "5️⃣ قیمت همکاری : " . $servicePartnersPrice
                    . "\n\n" . "6️⃣ تعداد کاربر : " . $serviceMultiLogin
                    . "\n\n" . "7️⃣ وضعیت : " . $serviceStatus;
            }
            return ['keyboard' => $keyboard, 'text' => $text];
        }
        else {
            if ($custom)
            {
                return [
                    'name' => $serviceName,
                    'ibsng_group_name' => $serviceGroup,
                    'days_price' => $daysPrice,
                    'volume_price' => $volumePrice,
                    'multi_price' => $multiPrice,
                    'status' => $serviceStatus
                ];
            }
            return [
                'name' => $serviceName,
                'ibsng_group_name' => $serviceGroup,
                'price' => $servicePrice,
                'rechargePrice' => $serviceRechargePrice,
                'partnersPrice' => $servicePartnersPrice,
                'multiLogin' => $serviceMultiLogin,
                'credit' => $serviceCredit,
                'status' => $serviceStatus
            ];
        }
    }

    public function editService($serviceId, $action)
    {
        if ($action == "remove") {
            $this->dataBase->deleteFromDB("services", "id='$serviceId'");
            $this->botFunctions->sendMessage(text: "سرویس با موفقیت حذف شد✅");
            return ['result' => "main"];
        }
        else if ($action == "name") {
            $this->botFunctions->sendMessage("لطفا نام سرویس جدید را وارد کنید");
            $this->botFunctions->setStep("editSelectedService-name-$serviceId");
        }
        else if ($action == "ibsng_group_name") {
            $this->adminIbsng = new adminIbsng($this->botFunctions, $this->dataBase, $this, $this->IBSngHandlers);
            $keyboard = $this->adminIbsng->ibsngGroupKeyboard("ibsng_group_name");
            $this->botFunctions->sendMessage("لطفا گروه جدید را انتخاب کنید", keyboardInput: $keyboard);
            $this->botFunctions->setStep("editSelectedService-ibsng_group_name-$serviceId");
        }
        else if ($action == "price") {
            $this->botFunctions->sendMessage("لطفا قیمت سرویس خود را به تومان وارد کنید" . "\n\n" . "مثال : 100000 (صد هزارتومان)");
            $this->botFunctions->setStep("editSelectedService-price-$serviceId");
        }
        else if ($action == "recharge_price") {
            $this->botFunctions->sendMessage("لطفا قیمت تمدید سرویس خود را به تومان وارد کنید" . "\n\n" . "مثال : 100000 (صد هزارتومان)");
            $this->botFunctions->setStep("editSelectedService-recharge_price-$serviceId");
        }
        else if ($action == "partners_price") {
            $this->botFunctions->sendMessage("لطفا قیمت همکار سرویس خود را به تومان وارد کنید" . "\n\n" . "مثال : 100000 (صد هزارتومان)");
            $this->botFunctions->setStep("editSelectedService-partners_price-$serviceId");
        }
        else if ($action == "multi_login") {
            $this->botFunctions->sendMessage("لطفا تعداد تعداد کاربر برای این سرویس را ارسال کنید" . "\n" . "این مقدار اولویت دارد بر مقدار تعداد کاربر گروه");
            $this->botFunctions->setStep("editSelectedService-multi_login-$serviceId");
        }
        else if ($action == "days_price") {
            $this->botFunctions->sendMessage("لطفا قیمت به ازای هر روز برای این سرویس را ارسال کنید");
            $this->botFunctions->setStep("editSelectedService-days_price-$serviceId");
        }
        else if ($action == "volume_price") {
            $this->botFunctions->sendMessage("لطفا قیمت به ازای هر گیگ برای این سرویس را ارسال کنید");
            $this->botFunctions->setStep("editSelectedService-volume_price-$serviceId");
        }
        else if ($action == "multi_price") {
            $this->botFunctions->sendMessage("لطفا قیمت به ازای هر کاربر برای این سرویس را ارسال کنید");
            $this->botFunctions->setStep("editSelectedService-multi_price-$serviceId");
        }

        else if ($action == "credit") {
            $this->botFunctions->sendMessage("لطفا مقدار credit برای این سرویس را برحسب گیگابایت (GB) ارسال کنید");
            $this->botFunctions->setStep("editSelectedService-credit-$serviceId");
        }
        else if ($action == "status") {
            $this->changeServiceStatus($serviceId);
            $this->botFunctions->sendMessage("با موفقیت انجام شد✅");
            return ['result' => "updatePanel", 'value' => $serviceId];
        }
        return "";
    }

    public function editSelectedService(string $serviceId, string $table, mixed $value)
    {
        if ($table == "ibsng_group_name") {
            $value = explode("-", callback_data)[1];
        }
        if ($table == "credit") {
            $value = userText * (pow(1024, 2));
        }
        $this->dataBase->updateToDB("services", ["$table"], [$value], "id='$serviceId'");
        $this->botFunctions->sendMessage("با موفقیت انجام شد✅");
    }
}