<?php

namespace bot\admin\userFunctions;

use bot\admin\adminIbsng\adminIbsng;
use bot\admin\serviceFunctions\serviceFunctions;
use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/../generalFunctions.php';
require_once __DIR__ . '/../ibsng/IBSngHandlers.php';
require_once __DIR__ . '/serviceFunctions.php';
require_once __DIR__ . '/adminIbsng.php';

class userFunctions
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    private serviceFunctions $serviceFunctions;
    private adminIbsng $adminIbsng;

    public function __construct($generalFunctions, $generalDBFunctions, $IBSngHandlers = "", $serviceFunctions = "", $adminIbsng = "")
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $generalDBFunctions;
        $this->IBSngHandlers = $IBSngHandlers;
        $this->serviceFunctions = $serviceFunctions;
        $this->adminIbsng = $adminIbsng;
    }

    public function checkEditUser($data)
    {
        $attribute = $data[1];
        if ($attribute == "group_name") {
            $allGroups = $this->adminIbsng->ibsngGroupKeyboard("");
            $this->botFunctions->editMessage(text: "گروه مد نظر را انتخاب کنید", keyboardInput: $allGroups);
        }
        else {
            $this->botFunctions->sendMessage("لطفا مقدار جدید را ارسال کنید" . "\n"
                . "توجه 1: برای تاریخ انقضا لطفا تعداد روز را فقط ارسال کنید" . "\n"
                . "توجه 2: برای Credit مقدار را به گیگابایت ارسال کنید، درصورتی که مقدار منفی ارسال کنید از اعتبار کاربر کم خواهد شد");
        }
        $this->botFunctions->setStep(callback_data);
    }

    public function editUser($data, $userText)
    {
        $attribute = $data[1];
        if ($attribute == "normalAttrs") {
            $userPasswordEdit = $data[2];
            $userName = $data[3];
            $this->IBSngHandlers->editUser($userName, $attribute, $userText, $userPasswordEdit);
        }
        else if ($attribute == "group_name") {
            $userName = $data[2];
            $groupName = explode("-", callback_data)[1];
            $this->IBSngHandlers->editUser($userName, $attribute, $groupName);
        }
        else if ($attribute == "credit") {
            $credit = $userText * (1024 * 1024);
            $userName = $data[2];
            $userId = $this->getUserInfo($userName)['array']['userId'];
            $this->IBSngHandlers->changeCredit($userId, $credit);
        }
        else {
            $userName = $data[2];
            $this->IBSngHandlers->editUser($userName, $attribute, $userText);
        }
        $this->botFunctions->sendMessage("با موفقیت انجام شد✅");
    }

    public function getUserInfo($userName)
    {
        $accountInfo = $this->IBSngHandlers->getUserInfoArray($userName, TRUE);
        if (is_null($accountInfo)) {
            return ['result' => FALSE];
        }
        $creationTime = date("Y-m-d", strtotime($accountInfo['creation_date']));
        $firstLogin = $accountInfo['first_login'] == 0 ? "ندارد" : date("Y-m-d", strtotime($accountInfo['first_login']));
        $expireDate = $accountInfo['nearest_expire_date'] == 0 ? "ندارد" : date("Y-m-d", strtotime($accountInfo['nearest_expire_date']));

        $multiLogin = $accountInfo['user_multi'] == 0 ? $accountInfo['group_multi'] : $accountInfo['user_multi'];
        $multiLogin = max($multiLogin, 1);
        $remainCredit = $accountInfo['credit'] / (pow(1024, 2));

        $text = "1️⃣ نام کاربری : " . $accountInfo['username'] . "\n\n"
            . "2️⃣ پسورد : " . $accountInfo['password'] . "\n\n"
            . "3️⃣ تاریخ ساخت : " . $creationTime . "\n\n"
            . "4️⃣ اولین اتصال : " . $firstLogin . "\n\n"
            . "5️⃣ تاریخ انقضا : " . $expireDate . "\n\n"
            . "6️⃣ تعداد کاربر : " . $multiLogin . "\n\n";
//            . "7️⃣ اعتبار باقی مانده : " . $remainCredit . " گیگابایت";

        $array = [
            "username" => $accountInfo['username'],
            "password" => $accountInfo['password'],
            "creationDate" => $creationTime,
            "group" => $accountInfo['group'],
            "firstLogin" => $firstLogin,
            "expireDate" => $expireDate,
            "multiLogin" => $multiLogin,
            "userId" => $accountInfo['uid'],
            "remainCredit" => $remainCredit
        ];
        return ['result' => TRUE, 'text' => $text, 'array' => $array];
    }

    public function orderResponse($data, $userName)
    {
        $action = $data[1];
        if (in_array("custom", $data)) {
            $userId = $data[6];
        }
        else if (in_array("add", $data)) {
            $userId = $this->dataBase->selectFromDB("orders", ["telegram_id"], "order_id='$data[3]'")[0]['telegram_id'];
        }
        else {
            $userId = $data[4];
        }
        if ($action == "confirm") {
            if (in_array("custom", $data)) {
                $days = $data[3];
                $volume = $data[4];
                $multiLogin = $data[5];
                $this->confirmRequest($days, $volume, $multiLogin, $userId, "custom");
            }
            else if (in_array("add", $data)) {
                $orderDetails = $this->dataBase->selectFromDB("orders", ["*"], "order_id='$data[3]'")[0];
                $this->confirmRequest($orderDetails['telegram_id'], $orderDetails['data'], "", "", "add");
            }
            else {
                $serviceId = $data[2];
                $userId = $data[3];
                $reNewAccountId = $data[4];
                $this->confirmRequest($serviceId, "", $reNewAccountId, $userId);
            }
        }
        else if ($action == "reject_buy") {
            $this->botFunctions->sendMessage('خرید شما با موفقیت انجام نشد❌ ' . "\n\n" . "لطفا دوباره امتحان کنید یا با پشتیبان در ارتباط باشید🙏.", id: $userId);
        }
        else if ($action == "block") {
            $this->botFunctions->sendMessage('خرید شما با موفقیت انجام نشد❌ ' . "\n\n" . "بنابر تصمیم مدیریت شما در بلک لیست قرار گرفته اید.", id: $userId);
            $this->botFunctions->addBlackList($userId, $userName);
        }
    }

    private function confirmRequest($d1, $d2, $d3, $d4, $type = "normal"): void
    {
        if ($type == "custom") {
            $serviceId = $this->dataBase->selectFromDB("services", ["id"], "name='کاستوم'")[0]['id'];
            $days = $d1;
            $volume = $d2;
            $multiLogin = $d3;
            $chatId = $d4;
            while (TRUE) {
                $userName = $this->generateRandomUsername();
                $auth = $this->IBSngHandlers->getUserInfo($userName);
                if (!$auth['result']) {
                    break;
                }
            }
            $password = $this->generateRandomPassword();
            $serviceInfo = $this->serviceFunctions->getServiceDetails($serviceId, FALSE);
            $result = $this->IBSngHandlers->newUser($userName, $password, $serviceInfo['ibsng_group_name'], ($volume * pow(1024, 2)), $multiLogin);
            $this->IBSngHandlers->editUser($userName, "relExpDate", $days);
        }
        else if ($type == "add") {
            $chatId = $d1;
            $data = $d2;
            $data = explode("-", $data);
            $orderType = $data[0];
            $value = $data[1];
            $ibsUserName = $this->dataBase->selectFromDB("user_accounts", ["account_username"], "id='$data[2]'")[0]['account_username'];
            $oldUserInfo = $this->IBSngHandlers->getUserInfoArray($ibsUserName, "false");
            $userId = $oldUserInfo['uid'];
            if ($orderType == "days") {
                $x = $this->IBSngHandlers->addDays($ibsUserName, $value);
            }
            else if ($orderType == "volume") {
                $this->IBSngHandlers->changeCredit($userId, $value * pow(1024, 2));
            }
            else if ($orderType == "multi") {
                $this->IBSngHandlers->addMultiLogin($ibsUserName, $value);
            }
        }
        else {
            $serviceId = $d1;
            $chatId = $d4;
            $reNewAccountId = $d3;

            $serviceInfo = $this->serviceFunctions->getServiceDetails($serviceId, FALSE);
            $multiLogin = $serviceInfo['multiLogin'] == "از گروه" ? NULL : $serviceInfo['multiLogin'];
            if ($reNewAccountId != "false") {
                $ibsUserName = $this->dataBase->selectFromDB("user_accounts", ["account_username"], "id='$reNewAccountId'")[0]['account_username'];
                $result = $this->IBSngHandlers->reNewUser($ibsUserName, $serviceInfo);
                if ($result['result']) {
                    $this->botFunctions->sendMessage("تمدید اکانت " . $ibsUserName . " با موفقیت انجام شد✅", id: $chatId);
                }
                else {
                    $this->botFunctions->sendMessage("تمدید اکانت " . $ibsUserName . "  با موفقیت انجام نشد❌", id: $chatId);
                }
                return;
            }
            while (TRUE) {
                $userName = $this->generateRandomUsername();
                $auth = $this->IBSngHandlers->getUserInfo($userName);
                if (!$auth['result']) {
                    break;
                }
            }
            $password = $this->generateRandomPassword();
            $result = $this->IBSngHandlers->newUser($userName, $password, $serviceInfo['ibsng_group_name'], $serviceInfo['credit'], $multiLogin);
        }
        if ($result) {
            $this->botFunctions->sendMessage("سفارش شما با موفقیت انجام شد✅" . "\n" . "نام کاربری: " . $userName . "\n" . "رمز عبور: " . $password, id: $chatId);
            $this->dataBase->insertToDB("user_accounts", ['telegram_id', 'account_username'], [$chatId, $userName]);
        }
        else {
            $this->botFunctions->sendMessage("ثبت سفارش شما ناموفق بود❌" . "\n" . "لطفا با پشتیبانی در ارتباط باشید", id: $chatId);
        }
    }

    private function generateRandomUsername($length = 6): string
    {
        $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $charactersLength = strlen($characters);
        $randomUsername = '';
        for ($i = 0; $i < $length; $i++) {
            $randomUsername .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomUsername;
    }

    private function generateRandomPassword($length = 4): string
    {
        $numbers = '0123456789';
        $numbersLength = strlen($numbers);
        $randomPassword = '';
        for ($i = 0; $i < $length; $i++) {
            $randomPassword .= $numbers[rand(0, $numbersLength - 1)];
        }
        return $randomPassword;
    }

    public function editAccount($userText)
    {
        $userInfo = $this->getUserInfo($userText);
        if (!$userInfo['result']) {
            $this->botFunctions->sendMessage("این کاربر وجود ندارد! ❌");
            return ['result' => 'main'];
        }
        $keyboard =
            [
                'inline_keyboard' =>
                    [
                        [
                            ['text' => 'ویرایش نام کاربری ✏️', 'callback_data' => 'editUser-normalAttrs-userName-' . $userText],
                            ['text' => 'ویرایش پسورد 🔑', 'callback_data' => 'editUser-normalAttrs-password-' . $userText]
                        ],
                        [
                            ['text' => 'ویرایش گروه 📂', 'callback_data' => 'editUser-group_name-' . $userText],
                            ['text' => 'ویرایش تاریخ انقضا 📅', 'callback_data' => 'editUser-relExpDate-' . $userText]
                        ],
                        [
                            ['text' => 'ویرایش تعداد کاربر 🔒', 'callback_data' => 'editUser-multi_login-' . $userText],
                            ['text' => 'ویرایش Credit 🔏', 'callback_data' => 'editUser-credit-' . $userText],
                        ],
                        [
                            back
                        ]
                    ]
            ];
        $this->botFunctions->sendMessage($userInfo['text'], keyboardInput: $keyboard);
        return "";
    }

    public function menu($callback_data, $userName)
    {
        if ($callback_data == "newAccount") {
            $groups = $this->adminIbsng->ibsngGroupKeyboard("newAccount");
            $this->botFunctions->editMessage(text: "ابتدا گروه را انتخاب کنید", keyboardInput: $groups);
        }
        else if ($callback_data == "reNewAccount") {
            $this->botFunctions->sendMessage("نام کاربری را ارسال کنید");
            $this->botFunctions->setStep("reNewAccount");
        }
        else if ($callback_data == "editAccount") {
            $this->botFunctions->sendMessage("نام کاربری را ارسال کنید");
            $this->botFunctions->setStep("editAccount");
        }
        else if ($callback_data == "reNewAllAccounts") {
            $this->botFunctions->sendMessage("تعداد روز مورد نظر برای اضافه شدن به تمامی کاربران را ارسال کنید");
            $this->botFunctions->setStep("reNewAllAccounts");
        }
        else {
            $info = $this->getUserInfo($userName);
            if (!$info['result']) {
                $this->botFunctions->sendMessage("این کاربر وجود ندارد ❌");
            }
            else {
                $this->botFunctions->sendMessage($info['text']);
            }
            $this->botFunctions->setStep("users");
            return ['result' => 'newPanel', 'keyboard' => usersManagementKeyboard, 'message' => "از منو زیر انتخاب کنید یا برای مشاهده وضعیت یک اکانت نام کاربری را ارسال کنید"];
        }
        return "";
    }

}