<?php

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/generalFunctions.php';
require_once __DIR__ . '/generalDBFunctions.php';
require_once __DIR__ . '/ibsng/IBSngHandlers.php';

class expireReminder
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;
    public function __construct()
    {
        $this->dataBase = new generalDBFunctions();
        $this->botFunctions = new generalFunctions();
        $this->IBSngHandlers = new \IBSngHandlers(IBSngConnection);
    }
    public function sendRenewReminder()
    {
        $allUsers = $this->dataBase->selectFromDB("user_accounts",["*"]);
        foreach ($allUsers as $user)
        {
            $userInfo = $this->IBSngHandlers->getUserInfoArray($user['account_username']);
            $data = $this->checkAccountExpire($userInfo);
            if ($data['result'])
            {
                $this->botFunctions->sendMessage(text: $data['message'], id: $user['telegram_id']);
            }
        }
    }
    private function checkAccountExpire($userInfo)
    {
        $expireTime = $userInfo['nearest_expire_date'];
        $username = $userInfo['username'];
        $remainDays = (strtotime($expireTime) - time()) / (3600*24);

        $remainText = "کاربر $username گرامی نارسیس وی پی ان
            \n
اعتبار سرویس VPN شما در مجموعه NarsisVpn در" . round($remainDays) . " روز آینده تمام خواهد شد.
برای تمدید لطفا به ربات و سپس قسمت مدیریت اکانت ها وارد شوید
\n
 نام کاربری شما: $username
\n
از اینکه مجموعه نارسیس وی پی ان را انتخاب کردید بسیار خرسندیم
\n
با احترام
همراه همیشگی شما نارسیس وی پی ان
            ";

        $finishedText = "کاربر $username گرامی نارسیس وی پی ان
            \n
اعتبار سرویس VPN شما در مجموعه NarsisVpn تمام شده است.
برای تمدید لطفا به ربات و سپس قسمت مدیریت اکانت ها وارد شوید
\n
 نام کاربری شما: $username
\n
از اینکه مجموعه نارسیس وی پی ان را انتخاب کردید بسیار خرسندیم
\n
با احترام
همراه همیشگی شما نارسیس وی پی ان
            ";

        if ($expireTime == 0) {
            return ['result' => FALSE];
        }
        if ($remainDays <= 3 and $remainDays > 0) {
            return ['result' => TRUE, 'message' => $remainText];
        }
        if ($remainDays > -3 and $remainDays <= 0)
        {
            return ['result' => TRUE, 'message' => $finishedText];
        }
        return ['result' => FALSE];
    }
}
$reminder = new expireReminder();
$reminder->sendRenewReminder();