<?php

namespace bot\user\serviceFunctions;

ini_set('display_errors', 1);

use bot\generalDBFunctions\generalDBFunctions;
use bot\generalFunctions\generalFunctions;

require_once __DIR__ . '/userKeyboards.php';

class serviceFunctions
{
    private generalFunctions $botFunctions;
    private generalDBFunctions $dataBase;
    private \IBSngHandlers $IBSngHandlers;

    public function __construct($generalFunctions, $dataBase, $IBSngHandlers)
    {
        $this->botFunctions = $generalFunctions;
        $this->dataBase = $dataBase;
        $this->IBSngHandlers = $IBSngHandlers;
    }

    public function getServices($isRenew = FALSE, $accountId = NULL)
    {
        $list = $this->dataBase->selectFromDB("services ORDER BY `services`.`id` ASC", ["*"]);
        $keyboard = [];
        foreach ($list as $service) {
            if ($service['status'] != "0" and !is_null($service['ibsng_group_name']) and !empty($service['ibsng_group_name']) and $service['name'] != "کاستوم") {
                if ($isRenew) {
                    $keyboard[] = ["text" => $service["name"], "callback_data" => "showService-" . $service["id"] . "-$accountId"];
                }
                else {
                    $keyboard[] = ["text" => $service["name"], "callback_data" => "showService-" . $service["id"]];
                }
            }
        }
        if (is_null($accountId)) {
            $keyboard[] = ["text" => "بازگشت⬅️", "callback_data" => "showService"];
        }
        else
        {
            $keyboard[] = ["text" => "بازگشت⬅️", "callback_data" => "editUserAccount-" . "$accountId"];

        }
//        $keyboard[] = ['text' => 'بازگشت⬅️', 'callback_data' => 'editUserAccount'];
        $final = array_chunk($keyboard, 1);
        return [
            'inline_keyboard' => $final
        ];
    }

    public function getServiceDetails($serviceId, $accountId = NULL)
    {
        $service = $this->dataBase->selectFromDB("services", ["*"], "id='$serviceId'")[0];
        $ibsngGroup = $service['ibsng_group_name'];
        $groupDetails = $this->IBSngHandlers->getGroupDetail($ibsngGroup);
        if (!$groupDetails['status']) {
            $this->botFunctions->sendMessage("این سرویس در دسترس نیست 🔴");
            return ['result' => FALSE];
        }
        $groupDetails = $groupDetails['data'];
        $multiLogin = max($groupDetails['multi_login_value'], 1);
        $expireValue = explode(" ", $groupDetails['rel_exp_combined'])[0];
        $expireType = explode(" ", $groupDetails['rel_exp_combined'])[1];
        $price = $this->isPartner(userId) ? $service['partners_price'] : (is_null($accountId) ? $service['price'] : $service['recharge_price']);
        $rechargePrice = $service['recharge_price'];
        switch ($expireType) {
            case "Years" :
                $expireType = "سال";
                break;
            case "Months":
                $expireType = "ماه";
                break;
            case "Days" :
                $expireType = "روز";
                break;
            case "Hours" :
                $expireType = "ساعت";
                break;
            case "Minutes" :
                $expireType = "دقیقه";
                break;
        }
        $expireTime = $expireValue . " " . $expireType;
        $text = "1️⃣ نام سرویس : " . $service['name'] . "\n\n" . "2️⃣ اعتبار : " . $expireTime . "\n\n"
            . "3️⃣ تعداد کاربر : " . $multiLogin . "\n\n";
        if (is_null($accountId)) {
            $text = $text . "4️⃣ قیمت : " . $price;
        }
        else {
            $text = $text . "4️⃣ قیمت تمدید : " . $rechargePrice;
        }
        $array = ['name' => $service['name'], 'days' => $expireTime, 'multiLogin' => $multiLogin, "price" => $price];
        return ['result' => TRUE, 'text' => $text, 'array' => $array];
    }

    public function buyServiceKeyboard($serviceId, $accountId = "false", $price = "false")
    {
        $gateways = $this->dataBase->selectFromDB("gateways", ["*"]);
        $keyboard = [];
        foreach ($gateways as $gateway) {
            if ($gateway['status'] == "1") {
                $keyboard[] = ['text' => $gateway['name'], 'callback_data' => "payService-normal-" . $gateway['id'] . "-$serviceId-$accountId-$price"];
            }
        }
        if (!is_null($accountId)) {
            $keyboard[] = ['text' => 'بازگشت⬅️', 'callback_data' => 'renewAccount-' . "$accountId"];
        }
        else {
            $keyboard[] = ['text' => 'بازگشت⬅️', 'callback_data' => 'buyService'];
        }
        $keyboard = array_chunk($keyboard, 2);
        return [
            'inline_keyboard' =>
                $keyboard
        ];
    }

    public function buyCustomServiceKeyboard($days, $volume, $multiLogin, $price)
    {
        $gateways = $this->dataBase->selectFromDB("gateways", ["*"]);
        $keyboard = [];
        foreach ($gateways as $gateway) {
            if ($gateway['status'] == "1") {
                $keyboard[] = ['text' => $gateway['name'], 'callback_data' => "payService-custom-" . $gateway['id'] . "-$days-$volume-$multiLogin-$price"];
            }
        }
        $keyboard[] = ['text' => 'بازگشت⬅️', 'callback_data' => 'buyService'];
        $keyboard = array_chunk($keyboard, 2);
        return [
            'inline_keyboard' =>
                $keyboard
        ];
    }

    public function buyAddCustomServiceKeyboard($orderId, $price)
    {
        $gateways = $this->dataBase->selectFromDB("gateways", ["*"]);
        $keyboard = [];
        foreach ($gateways as $gateway) {
            if ($gateway['status'] == "1") {
                $keyboard[] = ['text' => $gateway['name'], 'callback_data' => "payService-add-" . $gateway['id'] . "-$orderId-$price"];
            }
        }
        $keyboard[] = ['text' => 'بازگشت⬅️', 'callback_data' => 'buyService'];
        $keyboard = array_chunk($keyboard, 2);
        return [
            'inline_keyboard' =>
                $keyboard
        ];
    }


    public function checkCustomService()
    {
        $customService = $this->dataBase->selectFromDB("services", ["*"], "name='کاستوم'");
        if (empty($customService) or $this->isCustomEnable($customService[0])) {
            $this->botFunctions->sendMessage("این سرویس در دسترس نیست 🛑");
            return ['result' => FALSE];
        }
        return ['result' => TRUE, 'service' => $customService[0]];
    }

    public function isCustomEnable($service)
    {
        return ($service['status'] == 0 or $service['days_price'] == 0 or $service['volume_price'] == 0 or $service['multi_price'] == 0 or $service['ibsng_group_name'] == NULL or empty($service['ibsng_group_name']));
    }

    public function isPartner($userId)
    {
        $partners = $this->dataBase->selectFromDB("partners", ["telegram_id"]);
        $partners = array_column($partners, "telegram_id");
        return in_array($userId, $partners);
    }

    public function generateOrderId()
    {
        while (TRUE) {
            $orderId = mt_rand(100000, 999999);
            $order = $this->dataBase->selectFromDB("orders", ["*"], "order_id='$orderId'");
            if (empty($order)) {
                return $orderId;
            }
        }
    }
}